"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElandPythonClient = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ElandPythonClient = ({
  supportedNlpModels,
  nlpImportModel
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'm'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    steps: [{
      title: _i18n.i18n.translate('xpack.ml.trainedModels.addModelFlyout.elandPythonClient.step1Title', {
        defaultMessage: 'Install the Eland Python Client'
      }),
      children: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: 's',
        color: 'subdued'
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.trainedModels.addModelFlyout.elandPythonClient.pipInstallLabel",
        defaultMessage: "Eland can be installed with {pipLink} from {pypiLink}:",
        values: {
          pipLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: 'https://pypi.org/project/pip/',
            target: '_blank',
            external: true
          }, "pip"),
          pypiLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: 'https://pypi.org/',
            target: '_blank',
            external: true
          }, "PyPI")
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        isCopyable: true,
        language: "shell",
        fontSize: 'm',
        "data-test-subj": 'mlElandPipInstallCodeBlock'
      }, /*#__PURE__*/_react.default.createElement("p", null, "$ python -m pip install eland")), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: 's',
        color: 'subdued'
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.trainedModels.addModelFlyout.elandPythonClient.condaInstallLabel",
        defaultMessage: "or it can also be installed with {condaLink} from {condaForgeLink}:",
        values: {
          condaLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: 'https://docs.conda.io/',
            target: '_blank',
            external: true
          }, "Conda"),
          condaForgeLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: 'https://conda-forge.org/',
            target: '_blank',
            external: true
          }, "Conda Forge")
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        isCopyable: true,
        language: "shell",
        fontSize: 'm',
        "data-test-subj": "mlElandCondaInstallCodeBlock"
      }, /*#__PURE__*/_react.default.createElement("p", null, " $ conda install -c conda-forge eland")))
    }, {
      title: _i18n.i18n.translate('xpack.ml.trainedModels.addModelFlyout.elandPythonClient.step2Title', {
        defaultMessage: 'Importing your third-party model'
      }),
      children: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: 's',
        color: 'subdued'
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.trainedModels.addModelFlyout.elandPythonClient.step2Body",
        defaultMessage: "Follow the instructions on importing compatible third-party models"
      }))), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement("b", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.trainedModels.addModelFlyout.elandPythonClient.step2ExampleTitle",
        defaultMessage: "Example import"
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        isCopyable: true,
        language: "shell",
        fontSize: 'm',
        "data-test-subj": 'mlElandExampleImportCodeBlock'
      }, "eland_import_hub_model ", /*#__PURE__*/_react.default.createElement("br", null), "--cloud-id <cloud-id> \\ ", /*#__PURE__*/_react.default.createElement("br", null), "-u <username> -p <password> \\ ", /*#__PURE__*/_react.default.createElement("br", null), "--hub-model-id <model-id> \\ ", /*#__PURE__*/_react.default.createElement("br", null), "--task-type ner \\")), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: 's'
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        href: nlpImportModel,
        target: '_blank',
        iconType: 'help'
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.trainedModels.addModelFlyout.elandPythonClient.importModelButtonLabel",
        defaultMessage: "Import models with Eland"
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        href: supportedNlpModels,
        target: '_blank',
        iconType: 'help'
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.trainedModels.addModelFlyout.elandPythonClient.compatibleModelsButtonLabel",
        defaultMessage: "Compatible NLP models"
      })))))
    }, {
      title: _i18n.i18n.translate('xpack.ml.trainedModels.addModelFlyout.elandPythonClient.step4Title', {
        defaultMessage: 'Deploy your model'
      }),
      children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: 's',
        color: 'subdued'
      }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.trainedModels.addModelFlyout.elandPythonClient.step4Body",
        defaultMessage: "Click \u201CStart deployment\u201D in the table row containing your new model to deploy and use it."
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "m"
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        color: 'subdued'
      }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.trainedModels.addModelFlyout.elandPythonClient.step3Body",
        defaultMessage: "Note: The trained model list automatically refreshes with the most current imported models in your cluster. If the list is not updated, click the 'Refresh' button in the top right corner. Otherwise, revisit the instructions above to troubleshoot."
      }))))
    }]
  }));
};
exports.ElandPythonClient = ElandPythonClient;