"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateResultCallout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _page = require("../page");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CreateResultCallout = exports.CreateResultCallout = /*#__PURE__*/(0, _react.memo)(({
  saveState,
  resultsUrl,
  onReset
}) => {
  if (saveState === _page.SAVE_STATE.NOT_SAVED) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, saveState === _page.SAVE_STATE.SAVED && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJob.recognize.jobsCreatedTitle",
      defaultMessage: "Jobs created"
    }),
    color: "success",
    iconType: "checkInCircleFilled"
  }), saveState === _page.SAVE_STATE.FAILED && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJob.simple.recognize.jobsCreationFailedTitle",
      defaultMessage: "Jobs creation failed"
    }),
    color: "danger",
    iconType: "warning"
  }), saveState === _page.SAVE_STATE.PARTIAL_FAILURE && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJob.recognize.someJobsCreationFailedTitle",
      defaultMessage: "Some jobs failed to be created"
    }),
    color: "warning",
    iconType: "warning"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    alignItems: "center"
  }, saveState !== _page.SAVE_STATE.SAVING && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    fill: false,
    "aria-label": _i18n.i18n.translate('xpack.ml.newJob.recognize.jobsCreationFailed.resetButtonAriaLabel', {
      defaultMessage: 'Reset'
    }),
    onClick: onReset
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.recognize.someJobsCreationFailed.resetButtonLabel",
    defaultMessage: "Reset"
  }))), (saveState === _page.SAVE_STATE.SAVED || saveState === _page.SAVE_STATE.PARTIAL_FAILURE) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    fill: true,
    href: resultsUrl,
    "aria-label": _i18n.i18n.translate('xpack.ml.newJob.recognize.viewResultsAriaLabel', {
      defaultMessage: 'View results'
    })
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.recognize.viewResultsLinkText",
    defaultMessage: "View results"
  })))));
});