"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Scatter = void 0;
var _react = _interopRequireDefault(require("react"));
var _charts = require("@elastic/charts");
var _settings = require("../common/settings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SPEC_ID = 'scatter';
const scatterSeriesStyle = {
  ..._settings.lineSeriesStyle,
  line: {
    ..._settings.lineSeriesStyle.line,
    visible: false
  },
  point: {
    ..._settings.lineSeriesStyle.point,
    visible: 'always'
  }
};
const Scatter = ({
  chartData
}) => {
  const {
    LINE_COLOR
  } = (0, _settings.useChartColors)();
  return /*#__PURE__*/_react.default.createElement(_charts.LineSeries, {
    id: SPEC_ID
    // Defaults to multi layer time axis as of Elastic Charts v70
    ,
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: 'time',
    yAccessors: ['value'],
    data: chartData,
    curve: _charts.CurveType.CURVE_MONOTONE_X,
    lineSeriesStyle: scatterSeriesStyle,
    color: LINE_COLOR
  });
};
exports.Scatter = Scatter;