"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SuppliedConfigurationsButton = exports.AnomalyDetectionSettingsButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _use_create_url = require("../../../../contexts/kibana/use_create_url");
var _locator = require("../../../../../locator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SuppliedConfigurationsButton = () => {
  const redirectToSuppliedConfigurationsPage = (0, _use_create_url.useCreateAndNavigateToManagementMlLink)(_locator.ML_PAGES.SUPPLIED_CONFIGURATIONS, 'anomaly_detection');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "m",
    iconType: "listAdd",
    onClick: redirectToSuppliedConfigurationsPage,
    flush: "left",
    "data-test-subj": "mlSuppliedConfigurationsButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.suppliedConfigurationsManagementLabel",
    defaultMessage: "Supplied configurations"
  }));
};
exports.SuppliedConfigurationsButton = SuppliedConfigurationsButton;
const AnomalyDetectionSettingsButton = () => {
  const redirectToAnomalyDetectionSettingsPage = (0, _use_create_url.useCreateAndNavigateToManagementMlLink)('', 'ad_settings');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "m",
    iconType: "gear",
    onClick: redirectToAnomalyDetectionSettingsPage,
    flush: "left",
    "data-test-subj": "mlAnomalyDetectionSettingsButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.anomalyDetectionSettingsLabel",
    defaultMessage: "Settings"
  }));
};
exports.AnomalyDetectionSettingsButton = AnomalyDetectionSettingsButton;