"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobGroup = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _group_color_utils = require("../../../../../../common/util/group_color_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const JobGroup = ({
  name
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    key: `${name}-id`,
    "data-test-subj": "mlJobGroup",
    color: (0, _group_color_utils.tabColor)(name, euiTheme)
  }, name);
};
exports.JobGroup = JobGroup;