"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatavisualizerSelector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _esqlUtils = require("@kbn/esql-utils");
var _license = require("../license");
var _kibana = require("../contexts/kibana");
var _help_menu = require("../components/help_menu");
var _page_header = require("../components/page_header");
var _data_visualizer_grid = require("../overview/data_visualizer_grid");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function startTrialDescription() {
  return /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.datavisualizer.startTrial.fullMLFeaturesDescription",
    defaultMessage: "To experience the full Machine Learning features that a {subscriptionsLink} offers, start a 30-day trial.",
    values: {
      subscriptionsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: "https://www.elastic.co/subscriptions",
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.datavisualizer.startTrial.subscriptionsLinkText",
        defaultMessage: "Platinum or Enterprise subscription"
      }))
    }
  }));
}
const DatavisualizerSelector = () => {
  (0, _mlDatePicker.useTimefilter)({
    timeRangeSelector: false,
    autoRefreshSelector: false
  });
  const {
    services: {
      licenseManagement,
      http: {
        basePath
      },
      docLinks,
      dataVisualizer,
      uiSettings
    }
  } = (0, _kibana.useMlKibana)();
  const isEsqlEnabled = (0, _react.useMemo)(() => uiSettings.get(_esqlUtils.ENABLE_ESQL), [uiSettings]);
  const helpLink = docLinks.links.ml.guide;
  const startTrialVisible = licenseManagement !== undefined && licenseManagement.enabled === true && (0, _license.isFullLicense)() === false;
  if (dataVisualizer === undefined) {
    // eslint-disable-next-line no-console
    console.error('File data visualizer plugin not available');
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "mlPageDataVisualizerSelector"
  }, /*#__PURE__*/_react.default.createElement(_page_header.MlPageHeader, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.datavisualizer.selector.dataVisualizerTitle",
    defaultMessage: "Data Visualizer"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xl"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.datavisualizer.selector.dataVisualizerDescription",
    defaultMessage: "The Machine Learning Data Visualizer tool helps you understand your data by analyzing the metrics and fields in a log file or an existing Elasticsearch index."
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_data_visualizer_grid.DataVisualizerGrid, {
    buttonType: "full",
    isEsqlEnabled: isEsqlEnabled
  }), startTrialVisible === true && /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    gutterSize: "xl",
    columns: 2,
    style: {
      maxWidth: '1000px'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    hasBorder: true,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.datavisualizer.selector.startTrialTitle",
      defaultMessage: "Start trial"
    }),
    description: startTrialDescription(),
    footer: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      target: "_blank",
      href: `${basePath.get()}/app/management/stack/license_management/home`,
      "data-test-subj": "mlDataVisualizerStartTrialButton"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.datavisualizer.selector.startTrialButtonLabel",
      defaultMessage: "Start trial"
    })),
    "data-test-subj": "mlDataVisualizerCardStartTrial"
  }))))), /*#__PURE__*/_react.default.createElement(_help_menu.HelpMenu, {
    docLink: helpLink
  }));
};
exports.DatavisualizerSelector = DatavisualizerSelector;