"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataDriftIndexPatternsPicker = exports.DataDriftIndexOrSearchRedirect = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _queryString = require("query-string");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/saved-objects-finder-plugin/public");
var _public2 = require("@kbn/data-views-plugin/public");
var _router = require("../../routing/router");
var _locator = require("../../../../common/constants/locator");
var _data_drift_index_patterns_editor = require("./data_drift_index_patterns_editor");
var _page_header = require("../../components/page_header");
var _kibana = require("../../contexts/kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DataDriftIndexOrSearchRedirect = () => {
  const navigateToPath = (0, _kibana.useNavigateToPath)();
  const {
    contentManagement,
    uiSettings
  } = (0, _kibana.useMlKibana)().services;
  const {
    services: {
      dataViewEditor
    }
  } = (0, _kibana.useMlKibana)();
  const nextStepPath = '/data_drift';
  const onObjectSelection = (id, type) => {
    navigateToPath(`${nextStepPath}?${type === 'index-pattern' ? 'index' : 'savedSearchId'}=${encodeURIComponent(id)}`);
  };
  const canEditDataView = dataViewEditor === null || dataViewEditor === void 0 ? void 0 : dataViewEditor.userPermissions.editDataView();
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "mlPageSourceSelection"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
    restrictWidth: 1200
  }, /*#__PURE__*/_react.default.createElement(_page_header.MlPageHeader, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.selectDataViewOrSavedSearch",
    defaultMessage: "Select data view or saved Discover session"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_public.SavedObjectFinder, {
    id: "mlDataDriftDataViewsPicker",
    key: "searchSavedObjectFinder",
    onChoose: onObjectSelection,
    showFilter: true,
    noItemsMessage: _i18n.i18n.translate('xpack.ml.newJob.wizard.searchSelection.notFoundLabel', {
      defaultMessage: 'No matching data views or saved Discover sessions found.'
    }),
    savedObjectMetaData: [{
      type: 'search',
      getIconForSavedObject: () => 'discoverApp',
      name: _i18n.i18n.translate('xpack.ml.newJob.wizard.searchSelection.savedObjectType.discoverSession', {
        defaultMessage: 'Discover session'
      }),
      showSavedObject: savedObject =>
      // ES|QL Based saved searches are not supported in Data Drift, filter them out
      savedObject.attributes.isTextBasedQuery !== true
    }, {
      type: 'index-pattern',
      getIconForSavedObject: () => 'indexPatternApp',
      name: _i18n.i18n.translate('xpack.ml.newJob.wizard.searchSelection.savedObjectType.dataView', {
        defaultMessage: 'Data view'
      })
    }],
    fixedPageSize: 20,
    services: {
      contentClient: contentManagement.client,
      uiSettings
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    size: "m",
    fill: true,
    iconType: "plusInCircleFilled",
    onClick: () => navigateToPath((0, _router.createPath)(_locator.ML_PAGES.DATA_DRIFT_CUSTOM)),
    disabled: !canEditDataView,
    "data-test-subj": 'dataDriftCreateDataViewButton'
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.dataDrift.createDataViewButton",
    defaultMessage: "Create a data view"
  }))))));
};
exports.DataDriftIndexOrSearchRedirect = DataDriftIndexOrSearchRedirect;
const DataDriftIndexPatternsPicker = () => {
  const {
    reference,
    comparison
  } = (0, _queryString.parse)(location.search, {
    sort: false
  });
  const [dataViewEditorServices, setDataViewEditorServices] = (0, _react.useState)();
  const {
    services: {
      dataViewEditor,
      http,
      data: {
        dataViews
      }
    }
  } = (0, _kibana.useMlKibana)();
  const {
    dataViewEditorServiceFactory
  } = dataViewEditor;
  const initialComparisonIndexPattern = (0, _react.useMemo)(() => comparison ? comparison.replaceAll(`'`, '') : '', [comparison]);
  const initialReferenceIndexPattern = (0, _react.useMemo)(() => reference ? reference.replaceAll(`'`, '') : '', [reference]);
  (0, _react.useEffect)(() => {
    let unmounted = false;
    const getDataViewEditorService = async () => {
      if (http && dataViews && dataViewEditorServiceFactory) {
        const {
          DataViewEditorService
        } = await dataViewEditorServiceFactory();
        const referenceDataViewEditorService = new DataViewEditorService({
          // @ts-expect-error Mismatch in DataViewsServicePublic import, but should be same
          services: {
            http,
            dataViews
          },
          initialValues: {
            name: '',
            type: _public2.INDEX_PATTERN_TYPE.DEFAULT,
            indexPattern: initialReferenceIndexPattern
          },
          requireTimestampField: false
        });
        const comparisonDataViewEditorService = new DataViewEditorService({
          // @ts-expect-error Mismatch in DataViewsServicePublic import, but should be same
          services: {
            http,
            dataViews
          },
          initialValues: {
            name: '',
            type: _public2.INDEX_PATTERN_TYPE.DEFAULT,
            indexPattern: initialComparisonIndexPattern
          },
          requireTimestampField: false
        });
        if (!unmounted) {
          setDataViewEditorServices({
            referenceDataViewEditorService,
            comparisonDataViewEditorService
          });
        }
      }
    };
    getDataViewEditorService();
    return () => {
      unmounted = true;
    };
  }, [dataViewEditorServiceFactory, http, dataViews, initialReferenceIndexPattern, initialComparisonIndexPattern]);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "mlPageSourceSelection"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
    restrictWidth: 1200
  }, /*#__PURE__*/_react.default.createElement(_page_header.MlPageHeader, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.dataDrift.createDataDriftDataViewTitle",
    defaultMessage: "Create data view and analyze data drift"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, null, dataViewEditorServices ? /*#__PURE__*/_react.default.createElement(_data_drift_index_patterns_editor.DataDriftIndexPatternsEditor, {
    initialComparisonIndexPattern: initialComparisonIndexPattern,
    initialReferenceIndexPattern: initialReferenceIndexPattern,
    referenceDataViewEditorService: dataViewEditorServices.referenceDataViewEditorService,
    comparisonDataViewEditorService: dataViewEditorServices.comparisonDataViewEditorService
  }) : null)));
};
exports.DataDriftIndexPatternsPicker = DataDriftIndexPatternsPicker;