"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RegressionDecisionPath = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _d = _interopRequireDefault(require("d3"));
var _use_classification_path_data = require("./use_classification_path_data");
var _decision_path_chart = require("./decision_path_chart");
var _missing_decision_path_callout = require("./missing_decision_path_callout");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RegressionDecisionPath = ({
  baseline,
  featureImportance,
  predictedValue,
  predictionFieldName
}) => {
  const {
    decisionPathData
  } = (0, _use_classification_path_data.useDecisionPathData)({
    baseline,
    featureImportance,
    predictedValue
  });
  const domain = (0, _react.useMemo)(() => {
    let maxDomain;
    let minDomain;
    // if decisionPathData has calculated cumulative path
    if (decisionPathData && (0, _use_classification_path_data.isDecisionPathData)(decisionPathData)) {
      const [min, max] = _d.default.extent(decisionPathData, d => d[2]);
      maxDomain = max;
      minDomain = min;
      const buffer = Math.abs(maxDomain - minDomain) * 0.1;
      maxDomain = (typeof baseline === 'number' ? Math.max(maxDomain, baseline) : maxDomain) + buffer;
      minDomain = (typeof baseline === 'number' ? Math.min(minDomain, baseline) : minDomain) - buffer;
    }
    return {
      maxDomain,
      minDomain
    };
  }, [decisionPathData, baseline]);
  if (!decisionPathData) return /*#__PURE__*/_react.default.createElement(_missing_decision_path_callout.MissingDecisionPathCallout, null);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, baseline === undefined && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: 's',
    heading: 'p',
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.dataframe.analytics.explorationResults.missingBaselineCallout",
      defaultMessage: "Unable to calculate baseline value, which might result in a shifted decision path."
    }),
    color: "warning",
    iconType: "warning"
  }), /*#__PURE__*/_react.default.createElement(_decision_path_chart.DecisionPathChart, {
    decisionPathData: decisionPathData,
    predictionFieldName: predictionFieldName,
    minDomain: domain.minDomain,
    maxDomain: domain.maxDomain,
    baseline: baseline
  }));
};
exports.RegressionDecisionPath = RegressionDecisionPath;