"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Stat = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Stat = ({
  stat
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement("span", {
    css: {
      marginRight: euiTheme.size.s
    }
  }, /*#__PURE__*/_react.default.createElement("span", null, stat.label), ":", ' ', /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": `mlStatsBarStat ${stat.label.toLowerCase()} value`
  }, stat.value)));
};
exports.Stat = Stat;