"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedObjectsWarning = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _kibana = require("../../contexts/kibana");
var _job_spaces_sync = require("../job_spaces_sync");
var _check_capabilities = require("../../capabilities/check_capabilities");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SavedObjectsWarning = ({
  mlSavedObjectType,
  onCloseFlyout,
  forceRefresh
}) => {
  const {
    savedObjects: {
      syncCheck
    }
  } = (0, _kibana.useMlApi)();
  const mounted = (0, _react.useRef)(false);
  const [showWarning, setShowWarning] = (0, _react.useState)(false);
  const [showSyncFlyout, setShowSyncFlyout] = (0, _react.useState)(false);
  const [canCreateJob, canCreateDataFrameAnalytics, canCreateTrainedModels] = (0, _check_capabilities.usePermissionCheck)(['canCreateJob', 'canCreateDataFrameAnalytics', 'canCreateTrainedModels']);
  const canSync = (0, _react.useMemo)(() => canCreateJob || canCreateDataFrameAnalytics || canCreateTrainedModels, [canCreateDataFrameAnalytics, canCreateJob, canCreateTrainedModels]);
  const checkStatus = (0, _react.useCallback)(async () => {
    try {
      if (mounted.current === false) {
        return;
      }
      const {
        result
      } = await syncCheck(mlSavedObjectType);
      if (mounted.current === true) {
        setShowWarning(showSyncFlyout || result);
      }
    } catch (error) {
      console.log('Saved object synchronization check could not be performed.'); // eslint-disable-line no-console
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [showSyncFlyout, setShowWarning]);
  (0, _react.useEffect)(function initialStatusCheck() {
    mounted.current = true;
    if (forceRefresh === undefined || forceRefresh === true) {
      checkStatus();
    }
    return () => {
      mounted.current = false;
    };
  }, [forceRefresh, mounted, checkStatus]);
  const onClose = (0, _react.useCallback)(() => {
    setShowSyncFlyout(false);
    if (forceRefresh === undefined) {
      checkStatus();
    }
    if (typeof onCloseFlyout === 'function') {
      onCloseFlyout();
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [checkStatus, onCloseFlyout, setShowSyncFlyout]);
  (0, _react.useEffect)(function hideSyncFlyoutOnWarningClose() {
    if (showWarning === false && mounted.current === true) {
      setShowSyncFlyout(false);
    }
  }, [showWarning, setShowSyncFlyout]);
  return showWarning === false ? null : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.jobsList.missingSavedObjectWarning.title",
      defaultMessage: "ML job and trained model synchronization required"
    }),
    color: "warning",
    iconType: "warning",
    "data-test-subj": "mlJobSyncRequiredWarning"
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.jobsList.missingSavedObjectWarning.description",
    defaultMessage: "Some jobs or trained models are missing or have incomplete saved objects. "
  }), canSync ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.jobsList.missingSavedObjectWarning.link",
    defaultMessage: " {link}",
    values: {
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: setShowSyncFlyout.bind(null, true)
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.jobsList.missingSavedObjectWarning.linkToManagement.link",
        defaultMessage: "Synchronize your jobs and trained models."
      }))
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.jobsList.missingSavedObjectWarning.noPermission",
    defaultMessage: "An Administrator can synchronize the jobs and trained models in Stack Management."
  }), showSyncFlyout && /*#__PURE__*/_react.default.createElement(_job_spaces_sync.JobSpacesSyncFlyout, {
    onClose: onClose
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
};
exports.SavedObjectsWarning = SavedObjectsWarning;