"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultiSuperSelect = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_multi_super_select_styles = require("./use_multi_super_select_styles");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MultiSuperSelect = ({
  prepend,
  inputDisplay,
  options,
  onOptionsChange
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const styles = (0, _use_multi_super_select_styles.useMultiSuperSelectStyles)(isPopoverOpen);
  const closePopover = () => setIsPopoverOpen(false);
  const onPopoverButtonClick = () => setIsPopoverOpen(prev => !prev);
  const popoverButton = /*#__PURE__*/_react.default.createElement(_eui.EuiFormControlLayout, {
    isDropdown: true,
    prepend: prepend,
    compressed: true,
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onPopoverButtonClick,
    css: styles.control
  }, inputDisplay));

  // Handle changes to the options
  const handleOptionsChange = newOptions => {
    if (onOptionsChange) {
      onOptionsChange(newOptions);
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInputPopover, {
    input: popoverButton,
    isOpen: isPopoverOpen,
    closePopover: closePopover
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    options: options,
    onChange: handleOptionsChange,
    listProps: {
      showIcons: true
    }
  }, list => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, list)));
};
exports.MultiSuperSelect = MultiSuperSelect;