"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePartialState = usePartialState;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Custom hook for partial state update.
 */
function usePartialState(initialValue) {
  const [state, setState] = (0, _react.useState)(initialValue);
  const setFormStateCallback = update => {
    setState({
      ...state,
      ...update
    });
  };
  return [state, setFormStateCallback];
}