"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InfluencersCell = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _entity_cell_styles = require("../entity_cell/entity_cell_styles");
var _component_utils = require("../../util/component_utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * Component for rendering a list of record influencers inside a cell in the anomalies table.
 * Truncates long lists of influencers to the supplied limit, with the full list of influencers
 * expanded or collapsed via 'and x more' / 'show less' links.
 */
const InfluencersCell = ({
  influencers = [],
  influencerFilter,
  limit
}) => {
  const {
    filterButton
  } = (0, _entity_cell_styles.useEntityCellStyles)();
  const [showAllInfluencers, setShowAllInfluencers] = (0, _react.useState)(false);
  const toggleAllInfluencers = () => setShowAllInfluencers(prev => !prev);
  let numberToDisplay = showAllInfluencers === false ? limit : influencers.length;
  let othersCount = 0;
  if (influencers !== undefined) {
    othersCount = Math.max(influencers.length - numberToDisplay, 0);
  }
  if (othersCount === 1) {
    // Display the additional influencer.
    numberToDisplay++;
    othersCount = 0;
  }
  const displayInfluencers = influencers.reduce((acc, influencer) => {
    var _Object$entries$;
    const [influencerFieldName, influencerFieldValue] = (_Object$entries$ = Object.entries(influencer)[0]) !== null && _Object$entries$ !== void 0 ? _Object$entries$ : [];
    if (typeof influencerFieldName === 'string' && typeof influencerFieldValue === 'string') {
      acc.push({
        influencerFieldName,
        influencerFieldValue
      });
    }
    return acc;
  }, []).slice(0, numberToDisplay);
  return /*#__PURE__*/_react.default.createElement("div", null, displayInfluencers.map((influencer, index) => /*#__PURE__*/_react.default.createElement("div", {
    key: index
  }, influencer.influencerFieldName, ": ", influencer.influencerFieldValue, influencerFilter !== undefined && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.anomaliesTable.influencersCell.addFilterTooltip",
      defaultMessage: "Add filter"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    size: "s",
    css: filterButton,
    onClick: (0, _component_utils.blurButtonOnClick)(() => {
      influencerFilter(influencer.influencerFieldName, influencer.influencerFieldValue, '+');
    }),
    iconType: "plusInCircle",
    "aria-label": _i18n.i18n.translate('xpack.ml.anomaliesTable.influencersCell.addFilterAriaLabel', {
      defaultMessage: 'Add filter'
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.anomaliesTable.influencersCell.removeFilterTooltip",
      defaultMessage: "Remove filter"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    size: "s",
    css: filterButton,
    onClick: (0, _component_utils.blurButtonOnClick)(() => {
      influencerFilter(influencer.influencerFieldName, influencer.influencerFieldValue, '-');
    }),
    iconType: "minusInCircle",
    "aria-label": _i18n.i18n.translate('xpack.ml.anomaliesTable.influencersCell.removeFilterAriaLabel', {
      defaultMessage: 'Remove filter'
    })
  }))))), othersCount > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: () => toggleAllInfluencers()
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.anomaliesTable.anomalyDetails.anomalyDescriptionListMoreLinkText",
    defaultMessage: "and {othersCount} more",
    values: {
      othersCount
    }
  })), numberToDisplay > limit + 1 && /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: () => toggleAllInfluencers()
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.anomaliesTable.anomalyDetails.anomalyDescriptionShowLessLinkText",
    defaultMessage: "Show less"
  })));
};
exports.InfluencersCell = InfluencersCell;