"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAssetDetailsRedirect = void 0;
var _react = require("react");
var _reactRouterDom = require("react-router-dom");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _get_router_link_props = require("@kbn/router-utils/src/get_router_link_props");
var _common = require("@kbn/observability-shared-plugin/common");
var _use_kibana = require("../../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAssetDetailsRedirect = () => {
  const location = (0, _reactRouterDom.useLocation)();
  const {
    services: {
      application: {
        currentAppId$
      },
      share
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const appId = (0, _useObservable.default)(currentAppId$);
  const locator = share === null || share === void 0 ? void 0 : share.url.locators.get(_common.ASSET_DETAILS_LOCATOR_ID);
  const getAssetDetailUrl = (0, _react.useCallback)(({
    assetType,
    assetId,
    search
  }) => {
    var _location$state;
    const {
      to,
      from,
      ...rest
    } = search;
    const queryParams = {
      assetDetails: Object.keys(rest).length > 0 ? {
        ...rest,
        dateRange: {
          from: from ? new Date(from).toISOString() : undefined,
          to: to ? new Date(to).toISOString() : undefined
        }
      } : {},
      _a: {
        time: {
          ...(from ? {
            from: new Date(from).toISOString()
          } : undefined),
          ...(to ? {
            to: new Date(to).toISOString()
          } : undefined),
          interval: '>=1m'
        }
      }
    };
    const assetDetailsLocatorParams = {
      ...queryParams,
      assetType,
      assetId,
      state: {
        ...((_location$state = location.state) !== null && _location$state !== void 0 ? _location$state : {}),
        ...(location.key ? {
          originAppId: appId,
          originSearch: location.search,
          originPathname: location.pathname
        } : {})
      }
    };
    const assetDetailsLinkProps = (0, _get_router_link_props.getRouterLinkProps)({
      href: locator === null || locator === void 0 ? void 0 : locator.getRedirectUrl(assetDetailsLocatorParams),
      onClick: () => {
        locator === null || locator === void 0 ? void 0 : locator.navigate(assetDetailsLocatorParams, {
          replace: false
        });
      }
    });
    return assetDetailsLinkProps;
  }, [appId, location.key, location.pathname, location.search, location.state, locator]);
  return {
    getAssetDetailUrl
  };
};
exports.useAssetDetailsRedirect = useAssetDetailsRedirect;