"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.memoryUsed = exports.memoryUsage = exports.memoryFreeExcludingCache = exports.memoryFree = exports.memoryCache = void 0;
var _i18n = require("@kbn/i18n");
var _constants = require("../../../shared/charts/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const memoryCache = exports.memoryCache = {
  label: _i18n.i18n.translate('xpack.metricsData.assetDetails.formulas.metric.label.cache', {
    defaultMessage: 'cache'
  }),
  value: 'average(system.memory.used.bytes) - average(system.memory.actual.used.bytes)',
  format: 'bytes',
  decimals: 1
};
const memoryFree = exports.memoryFree = {
  label: _constants.MEMORY_FREE_LABEL,
  value: 'max(system.memory.total) - average(system.memory.actual.used.bytes)',
  format: 'bytes',
  decimals: 1
};
const memoryFreeExcludingCache = exports.memoryFreeExcludingCache = {
  label: _i18n.i18n.translate('xpack.metricsData.assetDetails.formulas.metric.label.free', {
    defaultMessage: 'free'
  }),
  value: 'average(system.memory.free)',
  format: 'bytes',
  decimals: 1
};
const memoryUsage = exports.memoryUsage = {
  label: _constants.MEMORY_USAGE_LABEL,
  value: 'average(system.memory.actual.used.pct)',
  format: 'percent',
  decimals: 0
};
const memoryUsed = exports.memoryUsed = {
  label: _i18n.i18n.translate('xpack.metricsData.assetDetails.formulas.metric.label.used', {
    defaultMessage: 'used'
  }),
  value: 'average(system.memory.actual.used.bytes)',
  format: 'bytes',
  decimals: 1
};