"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.network = void 0;
var _formulas = require("../formulas");
var _constants = require("../../../shared/charts/constants");
var _formulas$rx$label, _formulas$tx$label;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const rxTx = {
  id: 'rxTx',
  chartType: 'xy',
  title: _constants.NETWORK_LABEL,
  layers: [{
    seriesType: 'area',
    type: 'series',
    xAxis: '@timestamp',
    yAxis: [{
      ..._formulas.formulas.rx,
      label: _constants.RX_LABEL
    }, {
      ..._formulas.formulas.tx,
      label: _constants.TX_LABEL
    }]
  }],
  ..._constants.DEFAULT_XY_FITTING_FUNCTION,
  ..._constants.DEFAULT_XY_LEGEND,
  ..._constants.DEFAULT_XY_HIDDEN_AXIS_TITLE
};
const rx = {
  id: 'rx',
  chartType: 'xy',
  title: (_formulas$rx$label = _formulas.formulas.rx.label) !== null && _formulas$rx$label !== void 0 ? _formulas$rx$label : '',
  layers: [{
    seriesType: 'line',
    type: 'series',
    xAxis: '@timestamp',
    yAxis: [_formulas.formulas.rx]
  }],
  ..._constants.DEFAULT_XY_FITTING_FUNCTION,
  ..._constants.DEFAULT_XY_HIDDEN_LEGEND,
  ..._constants.DEFAULT_XY_HIDDEN_AXIS_TITLE
};
const tx = {
  id: 'tx',
  chartType: 'xy',
  title: (_formulas$tx$label = _formulas.formulas.tx.label) !== null && _formulas$tx$label !== void 0 ? _formulas$tx$label : '',
  layers: [{
    seriesType: 'line',
    type: 'series',
    xAxis: '@timestamp',
    yAxis: [_formulas.formulas.tx]
  }],
  ..._constants.DEFAULT_XY_FITTING_FUNCTION,
  ..._constants.DEFAULT_XY_HIDDEN_LEGEND,
  ..._constants.DEFAULT_XY_HIDDEN_AXIS_TITLE
};
const network = exports.network = {
  xy: {
    rxTx,
    rx,
    tx
  }
};