"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsAPISeriesRT = exports.MetricsAPIRowRT = exports.MetricsAPIResponseSeriesRT = exports.MetricsAPIResponseRT = exports.MetricsAPIRequestRT = exports.MetricsAPIPageInfoRT = exports.MetricsAPIMetricRT = exports.MetricsAPIColumnTypeRT = exports.MetricsAPIColumnRT = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _ioTsUtils = require("@kbn/io-ts-utils");
var _metrics_explorer = require("./metrics_explorer");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const groupByRT = rt.union([rt.string, rt.null, rt.undefined]);
const MetricsAPIMetricRT = exports.MetricsAPIMetricRT = rt.type({
  id: rt.string,
  aggregations: rt.UnknownRecord
});
const MetricsAPIRequestRT = exports.MetricsAPIRequestRT = rt.intersection([rt.type({
  timerange: _metrics_explorer.timeRangeRT,
  indexPattern: rt.string,
  metrics: rt.array(MetricsAPIMetricRT),
  includeTimeseries: rt.union([rt.boolean, (0, _ioTsUtils.createLiteralValueFromUndefinedRT)(true)])
}), rt.partial({
  groupBy: rt.array(groupByRT),
  groupInstance: rt.array(groupByRT),
  modules: rt.array(rt.string),
  afterKey: rt.union([rt.null, _metrics_explorer.afterKeyObjectRT]),
  limit: rt.union([rt.number, rt.null]),
  filters: rt.array(rt.UnknownRecord),
  dropPartialBuckets: rt.boolean,
  alignDataToEnd: rt.boolean
})]);
const MetricsAPIPageInfoRT = exports.MetricsAPIPageInfoRT = rt.intersection([rt.type({
  afterKey: rt.union([rt.null, _metrics_explorer.afterKeyObjectRT, rt.undefined])
}), rt.partial({
  interval: rt.number
})]);
const MetricsAPIColumnTypeRT = exports.MetricsAPIColumnTypeRT = rt.keyof({
  date: null,
  number: null,
  string: null
});
const MetricsAPIColumnRT = exports.MetricsAPIColumnRT = rt.type({
  name: rt.string,
  type: MetricsAPIColumnTypeRT
});
const MetricsAPIRowRT = exports.MetricsAPIRowRT = rt.intersection([rt.type({
  timestamp: rt.number
}), rt.record(rt.string, rt.union([rt.string, rt.number, rt.null, rt.undefined, rt.array(rt.object)]))]);
const MetricsAPISeriesRT = exports.MetricsAPISeriesRT = rt.intersection([rt.type({
  id: rt.string,
  columns: rt.array(MetricsAPIColumnRT),
  rows: rt.array(MetricsAPIRowRT)
}), rt.partial({
  keys: rt.array(rt.string)
})]);
const MetricsAPIResponseSeriesRT = exports.MetricsAPIResponseSeriesRT = rt.intersection([MetricsAPISeriesRT, rt.partial({
  metricsets: rt.array(rt.string)
})]);
const MetricsAPIResponseRT = exports.MetricsAPIResponseRT = rt.type({
  series: rt.array(MetricsAPIResponseSeriesRT),
  info: MetricsAPIPageInfoRT
});