"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TRACKED_LAYER_DESCRIPTOR = void 0;
exports.copyPersistentState = copyPersistentState;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TRACKED_LAYER_DESCRIPTOR = exports.TRACKED_LAYER_DESCRIPTOR = '__trackedLayerDescriptor';
function copyPersistentState(input) {
  if (typeof input !== 'object' || input === null) {
    // primitive
    return input;
  }
  const copyInput = Array.isArray(input) ? [] : {};
  for (const key in input) {
    if (!key.startsWith('__')) {
      // @ts-ignore
      copyInput[key] = copyPersistentState(input[key]);
    }
  }
  return copyInput;
}