"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FIT_TO_DATA_LABEL = exports.EDIT_LAYER_SETTINGS_LABEL = exports.EDIT_FEATURES_LABEL = void 0;
exports.getVisibilityToggleIcon = getVisibilityToggleIcon;
exports.getVisibilityToggleLabel = getVisibilityToggleLabel;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getVisibilityToggleIcon(isVisible) {
  return isVisible ? 'eyeClosed' : 'eye';
}
function getVisibilityToggleLabel(isVisible) {
  return isVisible ? _i18n.i18n.translate('xpack.maps.layerTocActions.hideLayerTitle', {
    defaultMessage: 'Hide layer'
  }) : _i18n.i18n.translate('xpack.maps.layerTocActions.showLayerTitle', {
    defaultMessage: 'Show layer'
  });
}
const EDIT_LAYER_SETTINGS_LABEL = exports.EDIT_LAYER_SETTINGS_LABEL = _i18n.i18n.translate('xpack.maps.layerControl.layerTocActions.layerSettingsButtonLabel', {
  defaultMessage: 'Edit layer settings'
});
const EDIT_FEATURES_LABEL = exports.EDIT_FEATURES_LABEL = _i18n.i18n.translate('xpack.maps.layerControl.layerTocActions.editFeaturesButtonLabel', {
  defaultMessage: 'Edit features'
});
const FIT_TO_DATA_LABEL = exports.FIT_TO_DATA_LABEL = _i18n.i18n.translate('xpack.maps.layerTocActions.fitToDataTitle', {
  defaultMessage: 'Fit to data'
});