"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddTooltipFieldPopover = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _reactField = require("@kbn/react-field");
var _fieldUtils = require("@kbn/field-utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* eslint-disable @typescript-eslint/consistent-type-definitions */

function sortByLabel(a, b) {
  return a.label.localeCompare(b.label);
}
function getOptions(fields, selectedFields) {
  if (!fields) {
    return [];
  }
  return fields.filter(field => {
    // remove selected fields
    const isFieldSelected = !!selectedFields.find(selectedField => {
      return field.name === selectedField.name;
    });
    return !isFieldSelected;
  }).map(field => {
    return {
      value: field.name,
      name: field.name,
      prepend: 'type' in field ? /*#__PURE__*/_react.default.createElement(_reactField.FieldIcon, {
        className: "eui-alignMiddle",
        type: field.type,
        fill: "none"
      }) : null,
      label: field.label
    };
  }).sort(sortByLabel);
}
class AddTooltipFieldPopover extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      isPopoverOpen: false,
      checkedFields: []
    });
    (0, _defineProperty2.default)(this, "_togglePopover", () => {
      this.setState(prevState => ({
        isPopoverOpen: !prevState.isPopoverOpen
      }));
    });
    (0, _defineProperty2.default)(this, "_closePopover", () => {
      this.setState({
        isPopoverOpen: false
      });
    });
    (0, _defineProperty2.default)(this, "_onSelect", options => {
      const checkedFields = options.filter(option => {
        return option.checked === 'on';
      }).map(option => {
        return option.value;
      });
      this.setState({
        checkedFields,
        options
      });
    });
    (0, _defineProperty2.default)(this, "_onAdd", () => {
      this.props.onAdd(this.state.checkedFields);
      this.setState({
        checkedFields: []
      });
      this._closePopover();
    });
  }
  static getDerivedStateFromProps(nextProps, prevState) {
    if (nextProps.fields !== prevState.prevFields || nextProps.selectedFields !== prevState.prevSelectedFields) {
      return {
        options: getOptions(nextProps.fields, nextProps.selectedFields),
        checkedFields: [],
        prevFields: nextProps.fields,
        prevSelectedFields: nextProps.selectedFields
      };
    }
    return null;
  }
  _renderAddButton() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: this._togglePopover,
      size: "xs",
      iconType: "plusInCircleFilled",
      isDisabled: !this.props.fields
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.tooltipSelector.togglePopoverLabel",
      defaultMessage: "Add"
    }));
  }
  _renderContent() {
    const addLabel = this.state.checkedFields.length === 0 ? _i18n.i18n.translate('xpack.maps.tooltipSelector.addLabelWithoutCount', {
      defaultMessage: 'Add'
    }) : _i18n.i18n.translate('xpack.maps.tooltipSelector.addLabelWithCount', {
      defaultMessage: 'Add {count}',
      values: {
        count: this.state.checkedFields.length
      }
    });
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
      searchable: true,
      searchProps: {
        compressed: true
      },
      options: this.state.options,
      onChange: this._onSelect,
      optionMatcher: _fieldUtils.comboBoxFieldOptionMatcher
    }, (list, search) => /*#__PURE__*/_react.default.createElement("div", {
      style: {
        width: '300px'
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
      paddingSize: "s"
    }, search), list)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, {
      paddingSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextAlign, {
      textAlign: "right"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: true,
      isDisabled: this.state.checkedFields.length === 0,
      onClick: this._onAdd,
      size: "s"
    }, addLabel))));
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      id: "addTooltipFieldPopover",
      anchorPosition: "leftCenter",
      button: this._renderAddButton(),
      isOpen: this.state.isPopoverOpen,
      closePopover: this._closePopover,
      panelPaddingSize: "none",
      ownFocus: true
    }, this._renderContent());
  }
}
exports.AddTooltipFieldPopover = AddTooltipFieldPopover;