"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFeatureCollectionBounds = getFeatureCollectionBounds;
var _bbox = _interopRequireDefault(require("@turf/bbox"));
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getFeatureCollectionBounds(featureCollection, hasJoins) {
  if (!featureCollection) {
    return null;
  }
  const visibleFeatures = hasJoins ? featureCollection.features.filter(feature => {
    return feature.properties && feature.properties[_constants.FEATURE_VISIBLE_PROPERTY_NAME];
  }) : featureCollection.features;
  if (visibleFeatures.length === 0) {
    return null;
  }
  const bbox = (0, _bbox.default)({
    type: 'FeatureCollection',
    features: visibleFeatures
  });
  return {
    minLon: bbox[0],
    minLat: bbox[1],
    maxLon: bbox[2],
    maxLat: bbox[3]
  };
}