"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StaticSizeForm = StaticSizeForm;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _validated_range = require("../../../../../components/validated_range");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function StaticSizeForm({
  onStaticStyleChange,
  staticDynamicSelect,
  styleProperty
}) {
  const onSizeChange = size => {
    onStaticStyleChange(styleProperty.getStyleName(), {
      size
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "mapStyleSettings__fixedBox"
  }, staticDynamicSelect), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_validated_range.ValidatedRange, {
    min: 0,
    max: 100,
    value: styleProperty.getOptions().size,
    onChange: onSizeChange,
    showInput: "inputWithPopover",
    showLabels: true,
    compressed: true,
    append: _i18n.i18n.translate('xpack.maps.vector.size.unitLabel', {
      defaultMessage: 'px',
      description: 'Shorthand for pixel'
    })
  })));
}