"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RowActionButtons = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ADD_BUTTON_TITLE = _i18n.i18n.translate('xpack.maps.addBtnTitle', {
  defaultMessage: 'Add'
});
const DELETE_BUTTON_TITLE = _i18n.i18n.translate('xpack.maps.deleteBtnTitle', {
  defaultMessage: 'Delete'
});
const RowActionButtons = ({
  onAdd,
  onRemove,
  showDeleteButton
}) => {
  return /*#__PURE__*/_react.default.createElement("div", null, showDeleteButton ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "trash",
    color: "danger",
    "aria-label": DELETE_BUTTON_TITLE,
    title: DELETE_BUTTON_TITLE,
    onClick: onRemove
  }) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "plusInCircle",
    color: "primary",
    "aria-label": ADD_BUTTON_TITLE,
    title: ADD_BUTTON_TITLE,
    onClick: onAdd
  }));
};
exports.RowActionButtons = RowActionButtons;