"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ESDistanceSource = exports.DEFAULT_WITHIN_DISTANCE = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../common/constants");
var _get_agg_key = require("../../../../../common/get_agg_key");
var _es_agg_source = require("../../es_agg_source");
var _valid_string_config = require("../../../util/valid_string_config");
var _execution_context_utils = require("../../execution_context_utils");
var _process_distance_response = require("./process_distance_response");
var _is_spatial_source_complete = require("../is_spatial_source_complete");
var _i18n_utils = require("../i18n_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_WITHIN_DISTANCE = exports.DEFAULT_WITHIN_DISTANCE = 5;
class ESDistanceSource extends _es_agg_source.AbstractESAggSource {
  static createDescriptor(descriptor) {
    const normalizedDescriptor = _es_agg_source.AbstractESAggSource.createDescriptor(descriptor);
    if (!(0, _valid_string_config.isValidStringConfig)(descriptor.geoField)) {
      throw new Error('Cannot create an ESDistanceSource without a geoField property');
    }
    return {
      ...normalizedDescriptor,
      geoField: descriptor.geoField,
      distance: typeof descriptor.distance === 'number' ? descriptor.distance : DEFAULT_WITHIN_DISTANCE,
      type: _constants.SOURCE_TYPES.ES_DISTANCE_SOURCE
    };
  }
  constructor(descriptor) {
    const sourceDescriptor = ESDistanceSource.createDescriptor(descriptor);
    super(sourceDescriptor);
    (0, _defineProperty2.default)(this, "_descriptor", void 0);
    this._descriptor = sourceDescriptor;
  }
  hasCompleteConfig() {
    return (0, _is_spatial_source_complete.isSpatialSourceComplete)(this._descriptor);
  }
  getOriginForField() {
    return _constants.FIELD_ORIGIN.JOIN;
  }
  getWhereQuery() {
    return this._descriptor.whereQuery;
  }
  getAggKey(aggType, fieldName) {
    return (0, _get_agg_key.getJoinAggKey)({
      aggType,
      aggFieldName: fieldName,
      rightSourceId: this._descriptor.id
    });
  }
  async getJoinMetrics(requestMeta, layerName, registerCancelCallback, inspectorAdapters, featureCollection) {
    if (featureCollection === undefined) {
      throw new Error(_i18n.i18n.translate('xpack.maps.esDistanceSource.noFeatureCollectionMsg', {
        defaultMessage: `Unable to perform distance join, features not provided. To enable distance join, select 'Limit results' in 'Scaling'`
      }));
    }
    if (!this.hasCompleteConfig()) {
      return {
        joinMetrics: new Map(),
        warnings: []
      };
    }
    const distance = `${this._descriptor.distance}km`;
    let hasFilters = false;
    const filters = {};
    for (let i = 0; i < featureCollection.features.length; i++) {
      var _feature$properties;
      const feature = featureCollection.features[i];
      if (feature.geometry.type === 'Point' && feature !== null && feature !== void 0 && (_feature$properties = feature.properties) !== null && _feature$properties !== void 0 && _feature$properties._id) {
        filters[feature.properties._id] = {
          geo_distance: {
            distance,
            [this._descriptor.geoField]: feature.geometry.coordinates
          }
        };
        if (!hasFilters) {
          hasFilters = true;
        }
      }
    }
    if (!hasFilters) {
      return {
        joinMetrics: new Map(),
        warnings: []
      };
    }
    const indexPattern = await this.getIndexPattern();
    const searchSource = await this.makeSearchSource(requestMeta, 0);
    searchSource.setField('trackTotalHits', false);
    searchSource.setField('aggs', {
      distance: {
        filters: {
          filters
        },
        aggs: this.getValueAggsDsl(indexPattern)
      }
    });
    const warnings = [];
    const rawEsData = await this._runEsQuery({
      requestId: this.getId(),
      requestName: (0, _i18n_utils.getJoinMetricsRequestName)(layerName),
      searchSource,
      registerCancelCallback,
      searchSessionId: requestMeta.searchSessionId,
      executionContext: (0, _execution_context_utils.mergeExecutionContext)({
        description: 'es_distance_source:distance_join_request'
      }, requestMeta.executionContext),
      requestsAdapter: inspectorAdapters.requests,
      onWarning: warning => {
        warnings.push(warning);
      }
    });
    return {
      joinMetrics: (0, _process_distance_response.processDistanceResponse)(rawEsData, this.getAggKey(_constants.AGG_TYPE.COUNT)),
      warnings
    };
  }
  isFilterByMapBounds() {
    return false;
  }
  getSyncMeta(dataFilters) {
    return {
      ...super.getSyncMeta(dataFilters),
      distance: this._descriptor.distance,
      geoField: this._descriptor.geoField
    };
  }
  getRightFields() {
    return this.getMetricFields();
  }
}
exports.ESDistanceSource = ESDistanceSource;
(0, _defineProperty2.default)(ESDistanceSource, "type", _constants.SOURCE_TYPES.ES_DISTANCE_SOURCE);