"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateSourceEditor = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _single_field_select = require("../../../components/single_field_select");
var _geo_index_pattern_select = require("../../../components/geo_index_pattern_select");
var _constants = require("../../../../common/constants");
var _index_pattern_util = require("../../../index_pattern_util");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RESET_INDEX_PATTERN_STATE = {
  indexPattern: undefined,
  geoFields: undefined,
  geoFieldName: undefined
};
class CreateSourceEditor extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      ...RESET_INDEX_PATTERN_STATE
    });
    (0, _defineProperty2.default)(this, "_onIndexPatternSelect", indexPattern => {
      const geoFields = (0, _index_pattern_util.getGeoFields)(indexPattern.fields);
      this.setState({
        ...RESET_INDEX_PATTERN_STATE,
        indexPattern,
        geoFields
      }, () => {
        if (geoFields.length) {
          // make default selection, prefer aggregatable field over the first available
          const firstAggregatableGeoField = geoFields.find(geoField => {
            return geoField.aggregatable;
          });
          const defaultGeoFieldName = firstAggregatableGeoField ? firstAggregatableGeoField : geoFields[0];
          this._onGeoFieldSelect(defaultGeoFieldName.name);
        }
      });
    });
    (0, _defineProperty2.default)(this, "_onGeoFieldSelect", geoFieldName => {
      this.setState({
        geoFieldName
      }, this._previewLayer);
    });
    (0, _defineProperty2.default)(this, "_previewLayer", () => {
      const {
        indexPattern,
        geoFieldName
      } = this.state;
      const field = geoFieldName && (indexPattern === null || indexPattern === void 0 ? void 0 : indexPattern.getFieldByName(geoFieldName));
      const sourceConfig = indexPattern && geoFieldName ? {
        indexPatternId: indexPattern.id,
        geoField: geoFieldName,
        scalingType: _constants.SCALING_TYPES.MVT
      } : null;
      const isPointsOnly = field ? field.type === 'geo_point' : false;
      this.props.onSourceConfigChange(sourceConfig, isPointsOnly);
    });
  }
  _renderGeoSelect() {
    if (!this.state.indexPattern) {
      return;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.maps.source.esSearch.geofieldLabel', {
        defaultMessage: 'Geospatial field'
      })
    }, /*#__PURE__*/_react.default.createElement(_single_field_select.SingleFieldSelect, {
      placeholder: _i18n.i18n.translate('xpack.maps.source.esSearch.selectLabel', {
        defaultMessage: 'Select geo field'
      }),
      value: this.state.geoFieldName ? this.state.geoFieldName : null,
      onChange: this._onGeoFieldSelect,
      fields: this.state.geoFields
    }));
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_geo_index_pattern_select.GeoIndexPatternSelect, {
      dataView: this.state.indexPattern,
      onChange: this._onIndexPatternSelect
    }), this._renderGeoSelect());
  }
}
exports.CreateSourceEditor = CreateSourceEditor;