"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.checkForDuplicateTitle = void 0;
var _i18n = require("@kbn/i18n");
var _links_content_management_client = require("./links_content_management_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const rejectErrorMessage = _i18n.i18n.translate('links.saveDuplicateRejectedDescription', {
  defaultMessage: 'Save with duplicate title confirmation was rejected'
});
const checkForDuplicateTitle = async ({
  id,
  title,
  lastSavedTitle,
  copyOnSave,
  isTitleDuplicateConfirmed,
  onTitleDuplicate
}) => {
  if (isTitleDuplicateConfirmed) {
    return true;
  }
  if (title === lastSavedTitle && !copyOnSave) {
    return true;
  }
  const {
    hits
  } = await _links_content_management_client.linksClient.search({
    text: `"${title}"`,
    limit: 10
  }, {
    onlyTitle: true
  });
  const existing = hits.find(obj => obj.attributes.title.toLowerCase() === title.toLowerCase());
  if (!existing || existing.id === id) {
    return true;
  }
  onTitleDuplicate();
  return Promise.reject(new Error(rejectErrorMessage));
};
exports.checkForDuplicateTitle = checkForDuplicateTitle;