"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ColorMappingByTerms = ColorMappingByTerms;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _coloring = require("@kbn/coloring");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _lens_ui_telemetry = require("../../lens_ui_telemetry");
var _palette_picker = require("../palette_picker");
var _palette_panel_container = require("./palette_panel_container");
var _utils = require("./utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ColorMappingByTerms({
  isDarkMode,
  colorMapping,
  palette,
  palettes,
  isInlineEditing,
  onModeChange,
  setPalette,
  setColorMapping,
  paletteService,
  panelRef,
  categories,
  formatter,
  allowCustomMatch
}) {
  var _colorMapping$assignm;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [useLegacyPalettes, setUseLegacyPalettes] = (0, _react.useState)(!colorMapping);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    label: _i18n.i18n.translate('xpack.lens.colorMapping.editColorMappingSectionLabel', {
      defaultMessage: 'Color mapping'
    }),
    css: {
      alignItems: 'center'
    },
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_palette_panel_container.PalettePanelContainer, {
    palette: (0, _utils.getPaletteDisplayColors)(paletteService, palettes, isDarkMode, palette, colorMapping),
    siblingRef: panelRef,
    title: !useLegacyPalettes ? _i18n.i18n.translate('xpack.lens.colorMapping.editColorMappingTitle', {
      defaultMessage: 'Assign colors to terms'
    }) : _i18n.i18n.translate('xpack.lens.colorMapping.editColorsTitle', {
      defaultMessage: 'Edit colors'
    }),
    isInlineEditing: isInlineEditing
  }, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "lns-palettePanel-terms",
    className: "lnsPalettePanel__section lnsPalettePanel__section--shaded lnsIndexPatternDimensionEditor--padded"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    justifyContent: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.lens.colorMapping.legacyLabel', {
      defaultMessage: 'Use legacy palettes'
    }), ' ', ((_colorMapping$assignm = colorMapping === null || colorMapping === void 0 ? void 0 : colorMapping.assignments.length) !== null && _colorMapping$assignm !== void 0 ? _colorMapping$assignm : 0) > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.lens.colorMapping.helpIncompatibleFieldDotLabel', {
        defaultMessage: 'Disabling Color Mapping will clear all assignments'
      }),
      position: "top",
      size: "s",
      type: "dot",
      color: euiTheme.colors.warning
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      color: "subdued",
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.lens.colorMapping.legacyPalettes",
        defaultMessage: "Legacy palettes will be replaced by the new color assignment experience in a future version."
      }),
      iconProps: {
        className: 'eui-alignTop'
      },
      position: "top",
      size: "s",
      type: "question"
    }))),
    "data-test-subj": "lns_colorMappingOrLegacyPalette_switch",
    compressed: true,
    checked: useLegacyPalettes,
    onChange: ({
      target: {
        checked: isLegacy
      }
    }) => {
      const newColorMapping = isLegacy ? undefined : palette ? (0, _coloring.getConfigFromPalette)(palettes, palette.name) : {
        ..._coloring.DEFAULT_COLOR_MAPPING_CONFIG
      };
      (0, _lens_ui_telemetry.trackUiCounterEvents)(`color_mapping_switch_${isLegacy ? 'disabled' : 'enabled'}`);
      setColorMapping(newColorMapping);
      setUseLegacyPalettes(isLegacy);
      onModeChange === null || onModeChange === void 0 ? void 0 : onModeChange(isLegacy);
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, !useLegacyPalettes ? /*#__PURE__*/_react.default.createElement(_coloring.CategoricalColorMapping, {
    isDarkMode: isDarkMode,
    model: colorMapping !== null && colorMapping !== void 0 ? colorMapping : {
      ..._coloring.DEFAULT_COLOR_MAPPING_CONFIG
    },
    onModelUpdate: setColorMapping,
    specialTokens: _coloring.SPECIAL_TOKENS_STRING_CONVERSION,
    palettes: palettes,
    formatter: formatter,
    allowCustomMatch: allowCustomMatch,
    data: {
      type: 'categories',
      categories
    }
  }) : /*#__PURE__*/_react.default.createElement(_palette_picker.PalettePicker, {
    palettes: paletteService,
    activePalette: palette,
    setPalette: setPalette
  }))))));
}