"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeActionApi = initializeActionApi;
var _public = require("@kbn/data-plugin/public");
var _esQuery = require("@kbn/es-query");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _lodash = require("lodash");
var _rxjs = require("rxjs");
var _presentationContainers = require("@kbn/presentation-containers");
var _react = _interopRequireDefault(require("react"));
var _show_underlying_data = require("../../app_plugin/show_underlying_data");
var _merged_search_context = require("../expressions/merged_search_context");
var _helper = require("../helper");
var _utils = require("../../utils");
var _mount = require("../mount");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getViewUnderlyingDataArgs({
  activeDatasource,
  activeDatasourceState,
  activeVisualization,
  activeVisualizationState,
  activeData,
  dataViews,
  capabilities,
  query,
  filters,
  timeRange,
  esQueryConfig
}) {
  const {
    error,
    meta
  } = (0, _show_underlying_data.getLayerMetaInfo)(activeDatasource, activeDatasourceState, activeVisualization, activeVisualizationState, activeData, dataViews, timeRange, capabilities);
  if (error || !meta) {
    return;
  }
  const luceneOrKuery = [];
  const aggregateQueries = [];
  if (Array.isArray(query)) {
    const [kqlOrLuceneQueries, esqlQueries] = (0, _lodash.partition)(query, _esQuery.isOfQueryType);
    if (kqlOrLuceneQueries.length) {
      luceneOrKuery.push(...kqlOrLuceneQueries);
    }
    if (esqlQueries.length) {
      aggregateQueries.push(...esqlQueries);
    }
  }
  const {
    filters: newFilters,
    query: newQuery
  } = (0, _show_underlying_data.combineQueryAndFilters)(luceneOrKuery.length > 0 ? luceneOrKuery : aggregateQueries[0], filters, meta, Object.values(dataViews), esQueryConfig);
  const dataViewSpec = dataViews[meta.id].spec;
  return {
    dataViewSpec,
    timeRange,
    filters: newFilters,
    query: aggregateQueries.length > 0 ? aggregateQueries[0] : newQuery,
    columns: meta.columns
  };
}
function loadViewUnderlyingDataArgs(state, {
  getVisualizationContext
}, searchContextApi, parentApi, {
  capabilities,
  uiSettings,
  injectFilterReferences,
  data,
  datasourceMap,
  visualizationMap
}) {
  var _capabilities$dashboa;
  const {
    activeAttributes,
    activeData,
    activeDatasourceState,
    activeVisualizationState,
    indexPatterns
  } = getVisualizationContext();
  const activeVisualizationId = (0, _utils.getActiveVisualizationIdFromDoc)(activeAttributes);
  const activeDatasourceId = (0, _utils.getActiveDatasourceIdFromDoc)(activeAttributes);
  const activeVisualization = activeVisualizationId ? visualizationMap[activeVisualizationId] : undefined;
  const activeDatasource = activeDatasourceId ? datasourceMap[activeDatasourceId] : undefined;
  if (!activeAttributes || !activeData || !activeDatasource || !activeDatasourceState || !activeVisualization || !activeVisualizationState) {
    return;
  }
  const {
    filters$,
    query$,
    timeRange$
  } = (0, _presentationPublishing.apiPublishesUnifiedSearch)(parentApi) ? parentApi : {
    filters$: undefined,
    query$: undefined,
    timeRange$: undefined
  };
  const mergedSearchContext = (0, _merged_search_context.getMergedSearchContext)(state, {
    filters: filters$ === null || filters$ === void 0 ? void 0 : filters$.getValue(),
    query: query$ === null || query$ === void 0 ? void 0 : query$.getValue(),
    timeRange: timeRange$ === null || timeRange$ === void 0 ? void 0 : timeRange$.getValue()
  }, searchContextApi.timeRange$, parentApi, {
    data,
    injectFilterReferences
  });
  if (!mergedSearchContext.timeRange) {
    return;
  }
  const viewUnderlyingDataArgs = getViewUnderlyingDataArgs({
    activeDatasource,
    activeDatasourceState,
    activeVisualization,
    activeVisualizationState,
    activeData,
    capabilities: {
      canSaveDashboards: Boolean((_capabilities$dashboa = capabilities.dashboard_v2) === null || _capabilities$dashboa === void 0 ? void 0 : _capabilities$dashboa.showWriteControls),
      canSaveVisualizations: Boolean(capabilities.visualize_v2.save),
      canOpenVisualizations: Boolean(capabilities.visualize_v2.show),
      navLinks: capabilities.navLinks,
      discover_v2: capabilities.discover_v2
    },
    query: mergedSearchContext.query,
    filters: mergedSearchContext.filters || [],
    timeRange: mergedSearchContext.timeRange,
    esQueryConfig: (0, _public.getEsQueryConfig)(uiSettings),
    dataViews: indexPatterns
  });
  return viewUnderlyingDataArgs;
}
function createViewUnderlyingDataApis(getState, internalApi, searchContextApi, parentApi, services) {
  let viewUnderlyingDataArgs;
  const canViewUnderlyingData$ = new _rxjs.BehaviorSubject(false);
  return {
    canViewUnderlyingData$,
    loadViewUnderlyingData: () => {
      viewUnderlyingDataArgs = loadViewUnderlyingDataArgs(getState(), internalApi, searchContextApi, parentApi, services);
      canViewUnderlyingData$.next(viewUnderlyingDataArgs != null);
    },
    getViewUnderlyingDataArgs: () => {
      return viewUnderlyingDataArgs;
    }
  };
}

/**
 * Initialize APIs used for actions on Lens panels
 * This includes drilldowns, explore data, and more
 */
function initializeActionApi(uuid, initialState, getLatestState, parentApi, searchContextApi, internalApi, services, dynamicActionsManager) {
  var _dynamicActionsManage, _dynamicActionsManage2;
  const maybeStopDynamicActions = dynamicActionsManager === null || dynamicActionsManager === void 0 ? void 0 : dynamicActionsManager.startDynamicActions();
  return {
    api: {
      ...((0, _helper.isTextBasedLanguage)(initialState) ? {} : (_dynamicActionsManage = dynamicActionsManager === null || dynamicActionsManager === void 0 ? void 0 : dynamicActionsManager.api) !== null && _dynamicActionsManage !== void 0 ? _dynamicActionsManage : {}),
      ...createViewUnderlyingDataApis(getLatestState, internalApi, searchContextApi, parentApi, services),
      mountInlineFlyout: (Component, overlayTracker, options = {}) => {
        (0, _mount.mountInlinePanel)(/*#__PURE__*/_react.default.createElement(Component, null), services.coreStart, overlayTracker !== null && overlayTracker !== void 0 ? overlayTracker : (0, _presentationContainers.tracksOverlays)(parentApi) ? parentApi : undefined, {
          uuid,
          ...options
        });
      }
    },
    anyStateChange$: (_dynamicActionsManage2 = dynamicActionsManager === null || dynamicActionsManager === void 0 ? void 0 : dynamicActionsManager.anyStateChange$) !== null && _dynamicActionsManage2 !== void 0 ? _dynamicActionsManage2 : new _rxjs.BehaviorSubject(undefined),
    getComparators: () => {
      var _dynamicActionsManage3;
      return {
        ...((_dynamicActionsManage3 = dynamicActionsManager === null || dynamicActionsManager === void 0 ? void 0 : dynamicActionsManager.comparators) !== null && _dynamicActionsManage3 !== void 0 ? _dynamicActionsManage3 : {
          enhancements: 'skip'
        })
      };
    },
    getLatestState: () => {
      var _dynamicActionsManage4;
      return (_dynamicActionsManage4 = dynamicActionsManager === null || dynamicActionsManager === void 0 ? void 0 : dynamicActionsManager.getLatestState()) !== null && _dynamicActionsManage4 !== void 0 ? _dynamicActionsManage4 : {};
    },
    cleanup: () => {
      maybeStopDynamicActions === null || maybeStopDynamicActions === void 0 ? void 0 : maybeStopDynamicActions.stopDynamicActions();
    },
    reinitializeState: lastSaved => {
      dynamicActionsManager === null || dynamicActionsManager === void 0 ? void 0 : dynamicActionsManager.reinitializeState(lastSaved !== null && lastSaved !== void 0 ? lastSaved : {});
    }
  };
}