"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ValuesInput = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _shared_components = require("../../../../../shared_components");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ValuesInput = ({
  value,
  onChange,
  minValue = 1,
  maxValue = 10000,
  label = _i18n.i18n.translate('xpack.lens.indexPattern.terms.size', {
    defaultMessage: 'Number of values'
  }),
  disabled
}) => {
  const [inputValue, setInputValue] = (0, _react.useState)(String(value));
  (0, _shared_components.useDebounceWithOptions)(() => {
    if (inputValue === '') {
      return;
    }
    const inputNumber = Number(inputValue);
    onChange(Math.min(maxValue, Math.max(inputNumber, minValue)));
  }, {
    skipFirstRender: true
  }, 256, [inputValue]);
  const isEmptyString = inputValue === '';
  const isHigherThanMax = !isEmptyString && Number(inputValue) > maxValue;
  const isLowerThanMin = !isEmptyString && Number(inputValue) < minValue;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: label,
    display: "rowCompressed",
    fullWidth: true,
    isInvalid: isHigherThanMax || isLowerThanMin,
    error: isHigherThanMax ? [_i18n.i18n.translate('xpack.lens.indexPattern.terms.sizeLimitMax', {
      defaultMessage: 'Value is higher than the maximum {max}, the maximum value is used instead.',
      values: {
        max: maxValue
      }
    })] : isLowerThanMin ? [_i18n.i18n.translate('xpack.lens.indexPattern.terms.sizeLimitMin', {
      defaultMessage: 'Value is lower than the minimum {min}, the minimum value is used instead.',
      values: {
        min: minValue
      }
    })] : null
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    fullWidth: true,
    min: minValue,
    max: maxValue,
    step: 1,
    value: inputValue,
    compressed: true,
    isInvalid: isHigherThanMax || isLowerThanMin,
    disabled: disabled,
    onChange: ({
      currentTarget
    }) => setInputValue(currentTarget.value),
    "aria-label": label,
    onBlur: () => {
      if (inputValue === '') {
        return setInputValue(String(value));
      }
      const inputNumber = Number(inputValue);
      setInputValue(String(Math.min(maxValue, Math.max(inputNumber, minValue))));
    },
    "data-test-subj": 'indexPattern-terms-values'
  }));
};
exports.ValuesInput = ValuesInput;