"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.supportsRarityRanking = supportsRarityRanking;
exports.supportsSignificantRanking = supportsSignificantRanking;
exports.termsOperation = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _public = require("@kbn/expressions-plugin/public");
var _react2 = require("@emotion/react");
var _constants = require("../../../../../../common/constants");
var _layer_helpers = require("../../layer_helpers");
var _values_input = require("./values_input");
var _helpers = require("../helpers");
var _field_inputs = require("./field_inputs");
var _field_input = require("../../../dimension_panel/field_input");
var _helpers2 = require("./helpers");
var _constants2 = require("./constants");
var _include_exclude_options = require("./include_exclude_options");
var _pure_utils = require("../../../pure_utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function supportsRarityRanking(field) {
  var _field$esTypes;
  // these es field types can't be sorted by rarity
  return !(field !== null && field !== void 0 && (_field$esTypes = field.esTypes) !== null && _field$esTypes !== void 0 && _field$esTypes.some(esType => ['double', 'float', 'half_float', 'scaled_float'].includes(esType)));
}
function supportsSignificantRanking(field) {
  var _field$esTypes2;
  return field === null || field === void 0 ? void 0 : (_field$esTypes2 = field.esTypes) === null || _field$esTypes2 === void 0 ? void 0 : _field$esTypes2.some(esType => esType === 'keyword');
}
function isRareOrSignificant(orderBy) {
  return orderBy.type === 'rare' || orderBy.type === 'significant';
}
const missingFieldLabel = _i18n.i18n.translate('xpack.lens.indexPattern.missingFieldLabel', {
  defaultMessage: 'Missing field'
});
function ofName(name, secondaryFieldsCount = 0, rare = false, significant = false, termsSize = 0) {
  if (rare) {
    return _i18n.i18n.translate('xpack.lens.indexPattern.rareTermsOf', {
      defaultMessage: 'Rare values of {name}',
      values: {
        name: name !== null && name !== void 0 ? name : missingFieldLabel
      }
    });
  }
  if (significant) {
    return _i18n.i18n.translate('xpack.lens.indexPattern.significantTermsOf', {
      defaultMessage: 'Significant values of {name}',
      values: {
        name: name !== null && name !== void 0 ? name : missingFieldLabel
      }
    });
  }
  if (secondaryFieldsCount) {
    return _i18n.i18n.translate('xpack.lens.indexPattern.multipleTermsOf', {
      defaultMessage: 'Top values of {name} + {count} {count, plural, one {other} other {others}}',
      values: {
        name: name !== null && name !== void 0 ? name : missingFieldLabel,
        count: secondaryFieldsCount
      }
    });
  }
  return _i18n.i18n.translate('xpack.lens.indexPattern.termsOf', {
    defaultMessage: 'Top {numberOfTermsLabel}{termsCount, plural, one {value} other {values}} of {name}',
    values: {
      name: name !== null && name !== void 0 ? name : missingFieldLabel,
      termsCount: termsSize,
      numberOfTermsLabel: termsSize > 1 ? `${termsSize} ` : ''
    }
  });
}

// It is not always possible to know if there's a numeric field, so just ignore it for now
function getParentFormatter(params) {
  var _params$secondaryFiel;
  return {
    id: (_params$secondaryFiel = params.secondaryFields) !== null && _params$secondaryFiel !== void 0 && _params$secondaryFiel.length ? 'multi_terms' : 'terms'
  };
}
const idPrefix = (0, _eui.htmlIdGenerator)()();
const termsOperation = exports.termsOperation = {
  type: 'terms',
  displayName: _i18n.i18n.translate('xpack.lens.indexPattern.terms', {
    defaultMessage: 'Top values'
  }),
  priority: 3,
  // Higher than any metric
  input: 'field',
  scale: () => 'ordinal',
  getCurrentFields: targetColumn => {
    var _targetColumn$params$, _targetColumn$params;
    return [targetColumn.sourceField, ...((_targetColumn$params$ = targetColumn === null || targetColumn === void 0 ? void 0 : (_targetColumn$params = targetColumn.params) === null || _targetColumn$params === void 0 ? void 0 : _targetColumn$params.secondaryFields) !== null && _targetColumn$params$ !== void 0 ? _targetColumn$params$ : [])];
  },
  getParamsForMultipleFields: ({
    targetColumn,
    sourceColumn,
    field,
    indexPattern
  }) => {
    const secondaryFields = new Set((0, _helpers2.getFieldsByValidationState)(indexPattern, targetColumn).validFields);
    const validFieldsToAdd = (0, _helpers2.getFieldsByValidationState)(indexPattern, sourceColumn, field).validFields;
    for (const validField of validFieldsToAdd) {
      secondaryFields.add(validField);
    }
    // remove the sourceField
    secondaryFields.delete(targetColumn.sourceField);
    const secondaryFieldsList = [...secondaryFields];
    const ret = {
      secondaryFields: secondaryFieldsList,
      parentFormat: getParentFormatter({
        ...targetColumn.params,
        secondaryFields: secondaryFieldsList
      })
    };
    return ret;
  },
  canAddNewField: ({
    targetColumn,
    sourceColumn,
    field,
    indexPattern
  }) => {
    var _targetColumn$params$2, _targetColumn$params2, _targetColumn$params3;
    if (isRareOrSignificant(targetColumn.params.orderBy)) {
      return false;
    }
    // collect the fields from the targetColumn
    const originalTerms = new Set((0, _helpers2.getFieldsByValidationState)(indexPattern, targetColumn).validFields);
    // now check how many fields can be added
    const {
      validFields
    } = (0, _helpers2.getFieldsByValidationState)(indexPattern, sourceColumn, field);
    const counter = validFields.filter(fieldName => !originalTerms.has(fieldName)).length;
    // reject when there are no new fields to add
    if (!counter) {
      return false;
    }
    return counter + ((_targetColumn$params$2 = (_targetColumn$params2 = targetColumn.params) === null || _targetColumn$params2 === void 0 ? void 0 : (_targetColumn$params3 = _targetColumn$params2.secondaryFields) === null || _targetColumn$params3 === void 0 ? void 0 : _targetColumn$params3.length) !== null && _targetColumn$params$2 !== void 0 ? _targetColumn$params$2 : 0) <= _field_inputs.MAX_MULTI_FIELDS_SIZE;
  },
  getDefaultVisualSettings: column => {
    var _column$params, _column$params$second;
    return {
      truncateText: Boolean(!((_column$params = column.params) !== null && _column$params !== void 0 && (_column$params$second = _column$params.secondaryFields) !== null && _column$params$second !== void 0 && _column$params$second.length))
    };
  },
  getPossibleOperationForField: ({
    aggregationRestrictions,
    aggregatable,
    type,
    timeSeriesMetric
  }) => {
    if (_constants2.supportedTypes.has(type) && aggregatable && timeSeriesMetric !== 'counter' && (!aggregationRestrictions || aggregationRestrictions.terms)) {
      return {
        dataType: type,
        isBucketed: true,
        scale: 'ordinal'
      };
    }
  },
  getErrorMessage: (layer, columnId, indexPattern) => {
    return [...(0, _helpers.getInvalidFieldMessage)(layer, columnId, indexPattern), ...(0, _helpers2.getDisallowedTermsMessage)(layer, columnId, indexPattern), ...(0, _helpers2.getMultiTermsScriptedFieldErrorMessage)(layer, columnId, indexPattern)];
  },
  getNonTransferableFields: (column, newIndexPattern) => {
    return (0, _helpers2.getFieldsByValidationState)(newIndexPattern, column).invalidFields;
  },
  isTransferable: (column, newIndexPattern) => {
    const {
      allFields,
      invalidFields
    } = (0, _helpers2.getFieldsByValidationState)(newIndexPattern, column);
    return Boolean(allFields.length && invalidFields.length === 0 && (!column.params.otherBucket || !newIndexPattern.hasRestrictions));
  },
  buildColumn({
    layer,
    field,
    indexPattern
  }, columnParams) {
    var _columnParams$size, _columnParams$orderBy, _columnParams$orderDi, _columnParams$otherBu, _columnParams$missing, _columnParams$parentF, _columnParams$include, _columnParams$exclude, _columnParams$include2, _columnParams$exclude2;
    const existingMetricColumn = Object.entries(layer.columns).filter(([columnId]) => (0, _helpers2.isSortableByColumn)(layer, columnId)).map(([id]) => id)[0];
    const previousBucketsLength = Object.values(layer.columns).filter(col => col && col.isBucketed).length;
    return {
      label: ofName(field.displayName),
      dataType: field.type,
      operationType: 'terms',
      sourceField: field.name,
      isBucketed: true,
      params: {
        size: (_columnParams$size = columnParams === null || columnParams === void 0 ? void 0 : columnParams.size) !== null && _columnParams$size !== void 0 ? _columnParams$size : previousBucketsLength === 0 ? 5 : _constants2.DEFAULT_SIZE,
        orderBy: (_columnParams$orderBy = columnParams === null || columnParams === void 0 ? void 0 : columnParams.orderBy) !== null && _columnParams$orderBy !== void 0 ? _columnParams$orderBy : existingMetricColumn ? {
          type: 'column',
          columnId: existingMetricColumn
        } : {
          type: 'alphabetical',
          fallback: true
        },
        orderAgg: (columnParams === null || columnParams === void 0 ? void 0 : columnParams.orderBy.type) === 'custom' ? columnParams === null || columnParams === void 0 ? void 0 : columnParams.orderAgg : undefined,
        orderDirection: (_columnParams$orderDi = columnParams === null || columnParams === void 0 ? void 0 : columnParams.orderDirection) !== null && _columnParams$orderDi !== void 0 ? _columnParams$orderDi : existingMetricColumn ? 'desc' : 'asc',
        otherBucket: ((_columnParams$otherBu = columnParams === null || columnParams === void 0 ? void 0 : columnParams.otherBucket) !== null && _columnParams$otherBu !== void 0 ? _columnParams$otherBu : true) && !indexPattern.hasRestrictions,
        missingBucket: (_columnParams$missing = columnParams === null || columnParams === void 0 ? void 0 : columnParams.missingBucket) !== null && _columnParams$missing !== void 0 ? _columnParams$missing : false,
        parentFormat: (_columnParams$parentF = columnParams === null || columnParams === void 0 ? void 0 : columnParams.parentFormat) !== null && _columnParams$parentF !== void 0 ? _columnParams$parentF : {
          id: 'terms'
        },
        include: (_columnParams$include = columnParams === null || columnParams === void 0 ? void 0 : columnParams.include) !== null && _columnParams$include !== void 0 ? _columnParams$include : [],
        exclude: (_columnParams$exclude = columnParams === null || columnParams === void 0 ? void 0 : columnParams.exclude) !== null && _columnParams$exclude !== void 0 ? _columnParams$exclude : [],
        includeIsRegex: (_columnParams$include2 = columnParams === null || columnParams === void 0 ? void 0 : columnParams.includeIsRegex) !== null && _columnParams$include2 !== void 0 ? _columnParams$include2 : false,
        excludeIsRegex: (_columnParams$exclude2 = columnParams === null || columnParams === void 0 ? void 0 : columnParams.excludeIsRegex) !== null && _columnParams$exclude2 !== void 0 ? _columnParams$exclude2 : false,
        secondaryFields: columnParams === null || columnParams === void 0 ? void 0 : columnParams.secondaryFields
      }
    };
  },
  toEsAggsFn: (column, columnId, _indexPattern, layer, uiSettings, orderedColumnIds, operationDefinitionMap) => {
    var _column$params2, _column$params3, _column$params4, _column$params5, _column$params5$secon, _column$params$includ2, _column$params$exclud2;
    if (((_column$params2 = column.params) === null || _column$params2 === void 0 ? void 0 : _column$params2.orderBy.type) === 'rare') {
      return (0, _public.buildExpressionFunction)('aggRareTerms', {
        id: columnId,
        enabled: true,
        schema: 'segment',
        field: column.sourceField,
        max_doc_count: column.params.orderBy.maxDocCount
      }).toAst();
    }

    // To get more accurate results, we set shard_size to a minimum of 1000
    // The other calculation matches the current Elasticsearch shard_size default,
    // but they may diverge in the future
    const shardSize = column.params.accuracyMode ? Math.max(1000, column.params.size * 1.5 + 10) : undefined;
    if (((_column$params3 = column.params) === null || _column$params3 === void 0 ? void 0 : _column$params3.orderBy.type) === 'significant') {
      var _column$params$includ, _column$params$exclud;
      return (0, _public.buildExpressionFunction)('aggSignificantTerms', {
        id: columnId,
        enabled: true,
        schema: 'segment',
        field: column.sourceField,
        size: column.params.size,
        shardSize,
        ...(((_column$params$includ = column.params.include) === null || _column$params$includ === void 0 ? void 0 : _column$params$includ.length) && {
          include: column.params.include
        }),
        ...(((_column$params$exclud = column.params.exclude) === null || _column$params$exclud === void 0 ? void 0 : _column$params$exclud.length) && {
          exclude: column.params.exclude
        })
      }).toAst();
    }
    let orderBy = '_key';
    if (((_column$params4 = column.params) === null || _column$params4 === void 0 ? void 0 : _column$params4.orderBy.type) === 'column') {
      const orderColumn = layer.columns[column.params.orderBy.columnId];
      orderBy = String(orderedColumnIds.indexOf(column.params.orderBy.columnId));
      // percentile rank with non integer value should default to alphabetical order
      if (!orderColumn || !(0, _helpers2.isPercentileRankSortable)(orderColumn) || !(0, _helpers2.isPercentileSortable)(orderColumn)) {
        orderBy = '_key';
      }
    }
    const orderAggColumn = column.params.orderAgg;
    let orderAgg;
    if (orderAggColumn) {
      orderBy = 'custom';
      const def = operationDefinitionMap === null || operationDefinitionMap === void 0 ? void 0 : operationDefinitionMap[orderAggColumn === null || orderAggColumn === void 0 ? void 0 : orderAggColumn.operationType];
      if (def && 'toEsAggsFn' in def) {
        orderAgg = [{
          type: 'expression',
          chain: [def.toEsAggsFn(orderAggColumn, `${columnId}-orderAgg`, _indexPattern, layer, uiSettings, orderedColumnIds)]
        }];
      }
    }
    if ((_column$params5 = column.params) !== null && _column$params5 !== void 0 && (_column$params5$secon = _column$params5.secondaryFields) !== null && _column$params5$secon !== void 0 && _column$params5$secon.length) {
      return (0, _public.buildExpressionFunction)('aggMultiTerms', {
        id: columnId,
        enabled: true,
        schema: 'segment',
        fields: [column.sourceField, ...column.params.secondaryFields],
        orderBy,
        order: column.params.orderDirection,
        orderAgg,
        size: column.params.size,
        shardSize,
        otherBucket: Boolean(column.params.otherBucket),
        otherBucketLabel: _i18n.i18n.translate('xpack.lens.indexPattern.terms.otherLabel', {
          defaultMessage: 'Other'
        })
      }).toAst();
    }
    return (0, _public.buildExpressionFunction)('aggTerms', {
      id: columnId,
      enabled: true,
      schema: 'segment',
      field: column.sourceField,
      orderBy,
      order: column.params.orderDirection,
      orderAgg,
      size: column.params.size,
      shardSize,
      ...(((_column$params$includ2 = column.params.include) === null || _column$params$includ2 === void 0 ? void 0 : _column$params$includ2.length) && {
        include: column.params.include
      }),
      ...(((_column$params$exclud2 = column.params.exclude) === null || _column$params$exclud2 === void 0 ? void 0 : _column$params$exclud2.length) && {
        exclude: column.params.exclude
      }),
      includeIsRegex: Boolean(column.params.includeIsRegex),
      excludeIsRegex: Boolean(column.params.excludeIsRegex),
      otherBucket: Boolean(column.params.otherBucket),
      otherBucketLabel: _i18n.i18n.translate('xpack.lens.indexPattern.terms.otherLabel', {
        defaultMessage: 'Other'
      }),
      missingBucket: column.params.otherBucket && column.params.missingBucket,
      missingBucketLabel: _i18n.i18n.translate('xpack.lens.indexPattern.terms.missingLabel', {
        defaultMessage: '(missing value)'
      })
    }).toAst();
  },
  getDefaultLabel: (column, columns, indexPattern) => {
    var _indexPattern$getFiel, _column$params$second2;
    return ofName(indexPattern === null || indexPattern === void 0 ? void 0 : (_indexPattern$getFiel = indexPattern.getFieldByName(column.sourceField)) === null || _indexPattern$getFiel === void 0 ? void 0 : _indexPattern$getFiel.displayName, (_column$params$second2 = column.params.secondaryFields) === null || _column$params$second2 === void 0 ? void 0 : _column$params$second2.length, column.params.orderBy.type === 'rare', column.params.orderBy.type === 'significant', column.params.size);
  },
  onFieldChange: (oldColumn, field, params) => {
    var _newParams$secondaryF;
    const newParams = {
      ...oldColumn.params,
      secondaryFields: undefined,
      ...params
    };
    if ('format' in newParams && field.type !== 'number') {
      delete newParams.format;
    }
    newParams.parentFormat = getParentFormatter(newParams);
    if (!supportsRarityRanking(field) && newParams.orderBy.type === 'rare' || !supportsSignificantRanking(field) && newParams.orderBy.type === 'significant') {
      newParams.orderBy = {
        type: 'alphabetical'
      };
    }
    return {
      ...oldColumn,
      dataType: field.type,
      label: oldColumn.customLabel ? oldColumn.label : ofName(field.displayName, (_newParams$secondaryF = newParams.secondaryFields) === null || _newParams$secondaryF === void 0 ? void 0 : _newParams$secondaryF.length, newParams.orderBy.type === 'rare', newParams.orderBy.type === 'significant', newParams.size),
      sourceField: field.name,
      params: newParams
    };
  },
  onOtherColumnChanged: (layer, thisColumnId) => {
    const columns = layer.columns;
    const currentColumn = columns[thisColumnId];
    if (currentColumn.params.orderBy.type === 'column' || currentColumn.params.orderBy.type === 'alphabetical' && currentColumn.params.orderBy.fallback) {
      // check whether the column is still there and still a metric
      const columnSortedBy = currentColumn.params.orderBy.type === 'column' ? columns[currentColumn.params.orderBy.columnId] : undefined;
      if (!columnSortedBy || currentColumn.params.orderBy.type === 'column' && !(0, _helpers2.isSortableByColumn)(layer, currentColumn.params.orderBy.columnId)) {
        // check whether we can find another metric column to sort by
        const existingMetricColumn = Object.entries(layer.columns).filter(([columnId]) => (0, _helpers2.isSortableByColumn)(layer, columnId)).map(([id]) => id)[0];
        return {
          ...currentColumn,
          params: {
            ...currentColumn.params,
            orderBy: existingMetricColumn ? {
              type: 'column',
              columnId: existingMetricColumn
            } : {
              type: 'alphabetical',
              fallback: true
            },
            orderDirection: existingMetricColumn ? 'desc' : 'asc'
          }
        };
      }
    }
    return currentColumn;
  },
  renderFieldInput: function FieldInput(props) {
    var _selectedColumn$param, _selectedColumn$param2, _selectedColumn$param3, _selectedColumn$param4;
    const {
      layer,
      selectedColumn,
      columnId,
      indexPattern,
      operationSupportMatrix,
      updateLayer,
      dimensionGroups,
      groupId,
      incompleteParams
    } = props;
    const onFieldSelectChange = (0, _react.useCallback)(fields => {
      const column = layer.columns[columnId];
      const [sourcefield, ...secondaryFields] = fields;
      const dataTypes = (0, _lodash.uniq)(fields.map(field => {
        var _indexPattern$getFiel2;
        return (_indexPattern$getFiel2 = indexPattern.getFieldByName(field)) === null || _indexPattern$getFiel2 === void 0 ? void 0 : _indexPattern$getFiel2.type;
      }));
      const newDataType = (dataTypes.length === 1 ? dataTypes[0] : 'string') || column.dataType;
      const newParams = {
        ...column.params
      };
      if ('format' in newParams && newDataType !== 'number') {
        delete newParams.format;
      }
      const mainField = indexPattern.getFieldByName(sourcefield);
      if (!supportsRarityRanking(mainField) && newParams.orderBy.type === 'rare' || !supportsSignificantRanking(mainField) && newParams.orderBy.type === 'significant') {
        newParams.orderBy = {
          type: 'alphabetical'
        };
      }
      // in single field mode, allow the automatic switch of the function to
      // the most appropriate one
      if (fields.length === 1) {
        const possibleOperations = operationSupportMatrix.operationByField.get(sourcefield);
        const termsSupported = possibleOperations === null || possibleOperations === void 0 ? void 0 : possibleOperations.has('terms');
        if (!termsSupported) {
          const newFieldOp = possibleOperations === null || possibleOperations === void 0 ? void 0 : possibleOperations.values().next().value;
          return updateLayer((0, _layer_helpers.insertOrReplaceColumn)({
            layer,
            columnId,
            indexPattern,
            op: newFieldOp,
            field: mainField,
            visualizationGroups: dimensionGroups,
            targetGroup: groupId,
            incompleteParams
          }));
        }
      }
      updateLayer({
        ...layer,
        columns: {
          ...layer.columns,
          [columnId]: {
            ...column,
            dataType: newDataType,
            sourceField: sourcefield,
            label: column.customLabel ? column.label : ofName(mainField === null || mainField === void 0 ? void 0 : mainField.displayName, fields.length - 1, newParams.orderBy.type === 'rare', newParams.orderBy.type === 'significant', newParams.size),
            params: {
              ...newParams,
              secondaryFields,
              parentFormat: getParentFormatter({
                ...newParams,
                secondaryFields
              })
            }
          }
        }
      });
    }, [columnId, dimensionGroups, groupId, incompleteParams, indexPattern, layer, operationSupportMatrix.operationByField, updateLayer]);
    const currentColumn = layer.columns[columnId];
    const fieldErrorMessage = (0, _field_input.getErrorMessage)(selectedColumn, Boolean(props.incompleteOperation), 'field', props.currentFieldIsInvalid);

    // let the default component do its job in case of incomplete informations
    if (!currentColumn || !selectedColumn || props.incompleteOperation || fieldErrorMessage && !((_selectedColumn$param = selectedColumn.params) !== null && _selectedColumn$param !== void 0 && (_selectedColumn$param2 = _selectedColumn$param.secondaryFields) !== null && _selectedColumn$param2 !== void 0 && _selectedColumn$param2.length)) {
      return /*#__PURE__*/_react.default.createElement(_field_input.FieldInput, props);
    }
    const showScriptedFieldError = (0, _helpers2.getMultiTermsScriptedFieldErrorMessage)(layer, columnId, indexPattern).length > 0;
    const {
      invalidFields
    } = (0, _helpers2.getFieldsByValidationState)(indexPattern, selectedColumn);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      "data-test-subj": "indexPattern-field-selection-row",
      label: _i18n.i18n.translate('xpack.lens.indexPattern.terms.chooseFields', {
        defaultMessage: '{count, plural, zero {Field} other {Fields}}',
        values: {
          count: ((_selectedColumn$param3 = selectedColumn.params) === null || _selectedColumn$param3 === void 0 ? void 0 : (_selectedColumn$param4 = _selectedColumn$param3.secondaryFields) === null || _selectedColumn$param4 === void 0 ? void 0 : _selectedColumn$param4.length) || 0
        }
      }),
      fullWidth: true,
      isInvalid: Boolean(showScriptedFieldError || invalidFields.length),
      error: (0, _field_inputs.getInputFieldErrorMessage)(showScriptedFieldError, invalidFields)
    }, /*#__PURE__*/_react.default.createElement(_field_inputs.FieldInputs, {
      column: selectedColumn,
      indexPattern: indexPattern,
      operationSupportMatrix: operationSupportMatrix,
      onChange: onFieldSelectChange,
      invalidFields: invalidFields,
      showTimeSeriesDimensions: (0, _pure_utils.shouldShowTimeSeriesOption)(layer, indexPattern, groupId, dimensionGroups)
    }));
  },
  quickFunctionDocumentation: _i18n.i18n.translate('xpack.lens.indexPattern.terms.documentation.quick', {
    defaultMessage: `
The top values of a specified field ranked by the chosen metric.
      `
  }),
  handleDataSectionExtra: true,
  paramEditor: function ParamEditor({
    layer,
    paramEditorUpdater,
    currentColumn,
    columnId,
    indexPattern,
    operationDefinitionMap,
    ReferenceEditor,
    paramEditorCustomProps,
    activeData,
    dataSectionExtra,
    ...rest
  }) {
    var _currentColumn$params, _currentColumn$params2, _indexPattern$getFiel4, _currentColumn$params3, _activeData$rest$laye;
    const [incompleteColumn, setIncompleteColumn] = (0, _react.useState)(undefined);
    const hasRestrictions = indexPattern.hasRestrictions;
    const SEPARATOR = '$$$';
    function toValue(orderBy) {
      if (orderBy.type !== 'column') {
        return orderBy.type;
      }
      return `${orderBy.type}${SEPARATOR}${orderBy.columnId}`;
    }
    function fromValue(value) {
      if (value === 'alphabetical') {
        return {
          type: 'alphabetical',
          fallback: false
        };
      }
      if (value === 'rare') {
        return {
          type: 'rare',
          maxDocCount: _constants2.DEFAULT_MAX_DOC_COUNT
        };
      }
      if (value === 'significant') {
        return {
          type: 'significant'
        };
      }
      if (value === 'custom') {
        return {
          type: 'custom'
        };
      }
      const parts = value.split(SEPARATOR);
      return {
        type: 'column',
        columnId: parts[1]
      };
    }
    const orderOptions = Object.entries(layer.columns).filter(([sortId]) => (0, _helpers2.isSortableByColumn)(layer, sortId)).map(([sortId, column]) => {
      return {
        value: toValue({
          type: 'column',
          columnId: sortId
        }),
        text: column.label
      };
    });
    orderOptions.push({
      value: toValue({
        type: 'alphabetical'
      }),
      text: _i18n.i18n.translate('xpack.lens.indexPattern.terms.orderAlphabetical', {
        defaultMessage: 'Alphabetical'
      })
    });
    if (!((_currentColumn$params = currentColumn.params.secondaryFields) !== null && _currentColumn$params !== void 0 && _currentColumn$params.length) && supportsRarityRanking(indexPattern.getFieldByName(currentColumn.sourceField))) {
      orderOptions.push({
        value: toValue({
          type: 'rare',
          maxDocCount: _constants2.DEFAULT_MAX_DOC_COUNT
        }),
        text: _i18n.i18n.translate('xpack.lens.indexPattern.terms.orderRare', {
          defaultMessage: 'Rarity'
        })
      });
    }
    if (!((_currentColumn$params2 = currentColumn.params.secondaryFields) !== null && _currentColumn$params2 !== void 0 && _currentColumn$params2.length) && supportsSignificantRanking(indexPattern.getFieldByName(currentColumn.sourceField))) {
      orderOptions.push({
        value: toValue({
          type: 'significant'
        }),
        text: _i18n.i18n.translate('xpack.lens.indexPattern.terms.orderSignificant', {
          defaultMessage: 'Significance'
        })
      });
    }
    orderOptions.push({
      value: toValue({
        type: 'custom'
      }),
      text: _i18n.i18n.translate('xpack.lens.indexPattern.terms.orderCustomMetric', {
        defaultMessage: 'Custom'
      })
    });
    const secondaryFieldsCount = currentColumn.params.secondaryFields ? currentColumn.params.secondaryFields.length : 0;
    const {
      euiTheme
    } = (0, _eui.useEuiTheme)();
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_values_input.ValuesInput, {
      value: currentColumn.params.size,
      disabled: currentColumn.params.orderBy.type === 'rare',
      onChange: value => {
        var _indexPattern$getFiel3;
        paramEditorUpdater({
          ...layer,
          columns: {
            ...layer.columns,
            [columnId]: {
              ...currentColumn,
              label: currentColumn.customLabel ? currentColumn.label : ofName((_indexPattern$getFiel3 = indexPattern.getFieldByName(currentColumn.sourceField)) === null || _indexPattern$getFiel3 === void 0 ? void 0 : _indexPattern$getFiel3.displayName, secondaryFieldsCount, currentColumn.params.orderBy.type === 'rare', currentColumn.params.orderBy.type === 'significant', value),
              params: {
                ...currentColumn.params,
                size: value,
                otherBucket: (0, _helpers2.getOtherBucketSwitchDefault)(currentColumn, value)
              }
            }
          }
        });
      }
    }), currentColumn.params.orderBy.type === 'rare' && /*#__PURE__*/_react.default.createElement(_values_input.ValuesInput, {
      value: currentColumn.params.orderBy.maxDocCount,
      label: _i18n.i18n.translate('xpack.lens.indexPattern.terms.maxDocCount', {
        defaultMessage: 'Max doc count per term'
      }),
      maxValue: _constants2.MAXIMUM_MAX_DOC_COUNT,
      onChange: value => {
        paramEditorUpdater((0, _layer_helpers.updateColumnParam)({
          layer,
          columnId,
          paramName: 'orderBy',
          value: {
            ...currentColumn.params.orderBy,
            maxDocCount: value
          }
        }));
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.lens.indexPattern.terms.orderBy', {
        defaultMessage: 'Rank by'
      }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        color: "subdued",
        content: _i18n.i18n.translate('xpack.lens.indexPattern.terms.orderByHelp', {
          defaultMessage: `Specifies the dimension the top values are ranked by.`
        }),
        iconProps: {
          className: 'eui-alignTop'
        },
        position: "top",
        size: "s",
        type: "question"
      })),
      display: "rowCompressed",
      fullWidth: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      compressed: true,
      fullWidth: true,
      "data-test-subj": "indexPattern-terms-orderBy",
      options: orderOptions,
      value: toValue(currentColumn.params.orderBy),
      onChange: e => {
        const newOrderByValue = fromValue(e.target.value);
        let updatedLayer = (0, _layer_helpers.updateDefaultLabels)((0, _layer_helpers.updateColumnParam)({
          layer,
          columnId,
          paramName: 'orderBy',
          value: newOrderByValue
        }), indexPattern);
        if (newOrderByValue.type === 'custom') {
          const initialOperation = operationDefinitionMap.count.buildColumn({
            layer,
            indexPattern,
            field: indexPattern.getFieldByName(_constants.DOCUMENT_FIELD_NAME)
          });
          updatedLayer = (0, _layer_helpers.updateColumnParam)({
            layer: updatedLayer,
            columnId,
            paramName: 'orderAgg',
            value: initialOperation
          });
        } else {
          updatedLayer = (0, _layer_helpers.updateColumnParam)({
            layer: updatedLayer,
            columnId,
            paramName: 'orderAgg',
            value: undefined
          });
        }
        setIncompleteColumn(undefined);
        paramEditorUpdater((0, _layer_helpers.updateColumnParam)({
          layer: updatedLayer,
          columnId,
          paramName: 'orderDirection',
          value: newOrderByValue.type === 'alphabetical' ? 'asc' : 'desc'
        }));
      },
      "aria-label": _i18n.i18n.translate('xpack.lens.indexPattern.terms.orderBy', {
        defaultMessage: 'Rank by'
      })
    })), currentColumn.params.orderAgg && ReferenceEditor && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(ReferenceEditor, (0, _extends2.default)({
      operationDefinitionMap: operationDefinitionMap,
      functionLabel: _i18n.i18n.translate('xpack.lens.indexPattern.terms.orderAgg.rankFunction', {
        defaultMessage: 'Rank function'
      }),
      fieldLabel: _i18n.i18n.translate('xpack.lens.indexPattern.terms.orderAgg.rankField', {
        defaultMessage: 'Rank field'
      }),
      isInline: true,
      paramEditorCustomProps: {
        ...paramEditorCustomProps,
        isInline: true,
        labels: getLabelForRankFunctions(currentColumn.params.orderAgg.operationType)
      },
      layer: layer,
      selectionStyle: "full",
      columnId: `${columnId}-orderAgg`,
      currentIndexPattern: indexPattern,
      paramEditorUpdater: setter => {
        if (!(0, _helpers.isColumn)(setter)) {
          throw new Error('Setter should always be a column when ran here.');
        }
        paramEditorUpdater((0, _layer_helpers.updateColumnParam)({
          layer,
          columnId,
          paramName: 'orderAgg',
          value: setter
        }));
      },
      column: currentColumn.params.orderAgg,
      incompleteColumn: incompleteColumn,
      onResetIncomplete: () => setIncompleteColumn(undefined),
      onDeleteColumn: () => {
        throw new Error('Should not be called');
      },
      onChooseField: choice => {
        const field = choice.field && indexPattern.getFieldByName(choice.field);
        if (field) {
          const hypotethicalColumn = operationDefinitionMap[choice.operationType].buildColumn({
            previousColumn: currentColumn.params.orderAgg,
            layer,
            indexPattern,
            field
          });
          setIncompleteColumn(undefined);
          paramEditorUpdater((0, _layer_helpers.updateColumnParam)({
            layer,
            columnId,
            paramName: 'orderAgg',
            value: hypotethicalColumn
          }));
        } else {
          setIncompleteColumn({
            sourceField: choice.field,
            operationType: choice.operationType
          });
        }
      },
      onChooseFunction: (operationType, field) => {
        if (field) {
          const hypotethicalColumn = operationDefinitionMap[operationType].buildColumn({
            previousColumn: currentColumn.params.orderAgg,
            layer,
            indexPattern,
            field
          });
          setIncompleteColumn(undefined);
          paramEditorUpdater((0, _layer_helpers.updateColumnParam)({
            layer,
            columnId,
            paramName: 'orderAgg',
            value: hypotethicalColumn
          }));
        } else {
          setIncompleteColumn({
            operationType
          });
        }
      },
      validation: {
        input: ['field', 'managedReference'],
        validateMetadata: meta => meta.dataType === 'number' && !meta.isBucketed
      }
    }, rest)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.lens.indexPattern.terms.orderDirection', {
        defaultMessage: 'Rank direction'
      }),
      display: "rowCompressed",
      fullWidth: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
      isFullWidth: true,
      legend: _i18n.i18n.translate('xpack.lens.indexPattern.terms.orderDirection', {
        defaultMessage: 'Rank direction'
      }),
      "data-test-subj": "indexPattern-terms-orderDirection-groups",
      buttonSize: "compressed",
      "aria-label": _i18n.i18n.translate('xpack.lens.indexPattern.terms.orderDirection', {
        defaultMessage: 'Rank direction'
      }),
      isDisabled: isRareOrSignificant(currentColumn.params.orderBy),
      options: [{
        id: `${idPrefix}asc`,
        'data-test-subj': 'indexPattern-terms-orderDirection-groups-asc',
        value: 'asc',
        label: _i18n.i18n.translate('xpack.lens.indexPattern.terms.orderAscending', {
          defaultMessage: 'Ascending'
        })
      }, {
        id: `${idPrefix}desc`,
        'data-test-subj': 'indexPattern-terms-orderDirection-groups-desc',
        value: 'desc',
        label: _i18n.i18n.translate('xpack.lens.indexPattern.terms.orderDescending', {
          defaultMessage: 'Descending'
        })
      }],
      idSelected: `${idPrefix}${currentColumn.params.orderDirection}`,
      onChange: id => {
        const value = id.replace(idPrefix, '');
        paramEditorUpdater((0, _layer_helpers.updateColumnParam)({
          layer,
          columnId,
          paramName: 'orderDirection',
          value
        }));
      }
    })), dataSectionExtra && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), dataSectionExtra), !hasRestrictions && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
      css: (0, _react2.css)`
                color: ${euiTheme.colors.primary};
              `,
      id: "lnsTermsAdvanced",
      arrowProps: {
        color: 'primary'
      },
      buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "xxs"
      }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
        color: euiTheme.colors.primary
      }, _i18n.i18n.translate('xpack.lens.indexPattern.terms.advancedSettings', {
        defaultMessage: 'Advanced'
      })))),
      "data-test-subj": "indexPattern-terms-advanced",
      className: "lnsIndexPatternDimensionEditor-advancedOptions"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs"
      }, _i18n.i18n.translate('xpack.lens.indexPattern.terms.missingBucketDescription', {
        defaultMessage: 'Include documents without the selected field'
      })),
      compressed: true,
      disabled: !currentColumn.params.otherBucket || ((_indexPattern$getFiel4 = indexPattern.getFieldByName(currentColumn.sourceField)) === null || _indexPattern$getFiel4 === void 0 ? void 0 : _indexPattern$getFiel4.type) !== 'string' || isRareOrSignificant(currentColumn.params.orderBy),
      "data-test-subj": "indexPattern-terms-missing-bucket",
      checked: Boolean(currentColumn.params.missingBucket),
      onChange: e => paramEditorUpdater((0, _layer_helpers.updateColumnParam)({
        layer,
        columnId,
        paramName: 'missingBucket',
        value: e.target.checked
      }))
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs"
      }, _i18n.i18n.translate('xpack.lens.indexPattern.terms.otherBucketDescription', {
        defaultMessage: 'Group remaining values as "Other"'
      })),
      compressed: true,
      "data-test-subj": "indexPattern-terms-other-bucket",
      checked: Boolean(currentColumn.params.otherBucket),
      disabled: isRareOrSignificant(currentColumn.params.orderBy),
      onChange: e => paramEditorUpdater((0, _layer_helpers.updateColumnParam)({
        layer,
        columnId,
        paramName: 'otherBucket',
        value: e.target.checked
      }))
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs"
      }, _i18n.i18n.translate('xpack.lens.indexPattern.terms.accuracyModeDescription', {
        defaultMessage: 'Enable accuracy mode'
      }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        color: "subdued",
        content: _i18n.i18n.translate('xpack.lens.indexPattern.terms.accuracyModeHelp', {
          defaultMessage: `Improves results for high-cardinality data, but increases the load on the Elasticsearch cluster.`
        }),
        iconProps: {
          className: 'eui-alignTop'
        },
        position: "top",
        size: "s",
        type: "question"
      })),
      compressed: true,
      disabled: currentColumn.params.orderBy.type === 'rare',
      "data-test-subj": "indexPattern-accuracy-mode",
      checked: Boolean(currentColumn.params.accuracyMode && currentColumn.params.orderBy.type !== 'rare'),
      onChange: e => paramEditorUpdater((0, _layer_helpers.updateColumnParam)({
        layer,
        columnId,
        paramName: 'accuracyMode',
        value: e.target.checked
      }))
    }), (currentColumn.dataType === 'number' || currentColumn.dataType === 'string') && !((_currentColumn$params3 = currentColumn.params.secondaryFields) !== null && _currentColumn$params3 !== void 0 && _currentColumn$params3.length) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_include_exclude_options.IncludeExcludeRow, {
      include: currentColumn.params.include,
      exclude: currentColumn.params.exclude,
      includeIsRegex: Boolean(currentColumn.params.includeIsRegex),
      excludeIsRegex: Boolean(currentColumn.params.excludeIsRegex),
      tableRows: activeData === null || activeData === void 0 ? void 0 : (_activeData$rest$laye = activeData[rest.layerId]) === null || _activeData$rest$laye === void 0 ? void 0 : _activeData$rest$laye.rows,
      columnId: columnId,
      isNumberField: Boolean(currentColumn.dataType === 'number'),
      updateParams: (operation, operationValue, regex, regexValue) => paramEditorUpdater({
        ...layer,
        columns: {
          ...layer.columns,
          [columnId]: {
            ...currentColumn,
            params: {
              ...currentColumn.params,
              [operation]: operationValue,
              [regex]: regexValue
            }
          }
        }
      })
    })))));
  },
  getMaxPossibleNumValues: column => column.params.size + (column.params.otherBucket ? 1 : 0)
};
function getLabelForRankFunctions(operationType) {
  switch (operationType) {
    case 'last_value':
      return [_i18n.i18n.translate('xpack.lens.indexPattern.terms.lastValue.sortRankBy', {
        defaultMessage: 'Sort rank by'
      })];
    case 'percentile_rank':
      return [_i18n.i18n.translate('xpack.lens.indexPattern.terms.percentile.', {
        defaultMessage: 'Percentile ranks'
      })];
    default:
      return;
  }
}