"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createSessionStorageStateStorage = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * {@link IStateStorage} for storing state in browser {@link Storage}
 * {@link https://github.com/elastic/kibana/blob/main/src/platform/plugins/shared/kibana_utils/docs/state_sync/storages/session_storage.md | guide}
 * @public
 */

/**
 * Creates {@link ISessionStorageStateStorage}
 * {@link https://github.com/elastic/kibana/blob/main/src/platform/plugins/shared/kibana_utils/docs/state_sync/storages/session_storage.md | guide}
 * @param storage - Option {@link Storage} to use for storing state. By default window.sessionStorage.
 * @returns - {@link ISessionStorageStateStorage}
 * @public
 */
const createSessionStorageStateStorage = (storage = window.sessionStorage) => {
  return {
    set: (key, state) => storage.setItem(key, JSON.stringify(state)),
    get: key => JSON.parse(storage.getItem(key))
  };
};
exports.createSessionStorageStateStorage = createSessionStorageStateStorage;