"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RequestSelector = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _adapters = require("../../../../common/adapters");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class RequestSelector extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "handleSelected", selectedOptions => {
      const selectedOption = this.props.requests.find(request => request.id === selectedOptions[0].value);
      if (selectedOption) {
        this.props.onRequestChanged(selectedOption);
      }
    });
  }
  renderRequestCombobox() {
    const options = this.props.requests.map(item => {
      const hasFailed = item.status === _adapters.RequestStatus.ERROR;
      const testLabel = item.name.replace(/\s+/, '_');
      return {
        'data-test-subj': `inspectorRequestChooser${testLabel}`,
        label: hasFailed ? `${item.name} ${_i18n.i18n.translate('inspector.requests.failedLabel', {
          defaultMessage: ' (failed)'
        })}` : item.name,
        value: item.id
      };
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      "data-test-subj": "inspectorRequestChooser",
      fullWidth: true,
      id: "inspectorRequestChooser",
      isClearable: false,
      onChange: this.handleSelected,
      options: options,
      prepend: "Request",
      selectedOptions: [{
        label: this.props.selectedRequest.name,
        value: this.props.selectedRequest.id
      }],
      singleSelection: {
        asPlainText: true
      }
    });
  }
  render() {
    const {
      selectedRequest,
      requests
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true
    }, requests.length && this.renderRequestCombobox()), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, selectedRequest.status !== _adapters.RequestStatus.PENDING && /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "left",
      title: selectedRequest.status === _adapters.RequestStatus.OK ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "inspector.requests.requestSucceededTooltipTitle",
        defaultMessage: "Request succeeded"
      }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "inspector.requests.requestFailedTooltipTitle",
        defaultMessage: "Request failed"
      }),
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "inspector.requests.requestTooltipDescription",
        defaultMessage: "The total time the request took."
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      "data-test-subj": "inspectorRequestTotalTime",
      tabIndex: 0,
      color: selectedRequest.status === _adapters.RequestStatus.OK ? 'success' : 'danger',
      iconType: selectedRequest.status === _adapters.RequestStatus.OK ? 'check' : 'cross'
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "inspector.requests.requestTimeLabel",
      defaultMessage: "{requestTime}ms",
      values: {
        requestTime: selectedRequest.time
      }
    }))), selectedRequest.status === _adapters.RequestStatus.PENDING && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m",
      "aria-label": _i18n.i18n.translate('inspector.requests.requestInProgressAriaLabel', {
        defaultMessage: 'Request in progress'
      })
    })));
  }
}
exports.RequestSelector = RequestSelector;
(0, _defineProperty2.default)(RequestSelector, "propTypes", {
  requests: _propTypes.default.array.isRequired,
  selectedRequest: _propTypes.default.object.isRequired,
  onRequestChanged: _propTypes.default.func
});