"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useHealthHexCodes = useHealthHexCodes;
exports.useHeathBarLinearGradient = useHeathBarLinearGradient;
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function useHealthHexCodes() {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return {
    successful: euiTheme.colors.backgroundFilledSuccess,
    partial: euiTheme.colors.backgroundLightWarning,
    skipped: euiTheme.colors.backgroundFilledWarning,
    failed: euiTheme.colors.backgroundFilledDanger
  };
}
function useHeathBarLinearGradient(successful, partial, skipped, failed) {
  const healthHexCodes = useHealthHexCodes();
  const total = successful + partial + skipped + failed;
  const stops = [];
  let startPercent = 0;
  function addStop(value, color) {
    if (value <= 0) {
      return;
    }
    const percent = Math.round(value / total * 100);
    const endPercent = startPercent + percent;
    stops.push(`${color} ${startPercent}% ${endPercent}%`);
    startPercent = endPercent;
  }
  addStop(successful, healthHexCodes.successful);
  addStop(partial, healthHexCodes.partial);
  addStop(skipped, healthHexCodes.skipped);
  addStop(failed, healthHexCodes.failed);
  const printedStops = stops.map((stop, index) => {
    return index === stops.length - 1 ? stop : stop + ', ';
  }).join('');
  return `linear-gradient(to right, ${printedStops})`;
}