"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IngestPipelinesLocatorDefinition = exports.INGEST_PIPELINES_PAGES = exports.INGEST_PIPELINES_APP_LOCATOR = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _navigation = require("./application/services/navigation");
var _constants = require("../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let INGEST_PIPELINES_PAGES = exports.INGEST_PIPELINES_PAGES = /*#__PURE__*/function (INGEST_PIPELINES_PAGES) {
  INGEST_PIPELINES_PAGES["LIST"] = "pipelines_list";
  INGEST_PIPELINES_PAGES["EDIT"] = "pipeline_edit";
  INGEST_PIPELINES_PAGES["CREATE"] = "pipeline_create";
  INGEST_PIPELINES_PAGES["CLONE"] = "pipeline_clone";
  return INGEST_PIPELINES_PAGES;
}({});
const INGEST_PIPELINES_APP_LOCATOR = exports.INGEST_PIPELINES_APP_LOCATOR = 'INGEST_PIPELINES_APP_LOCATOR';
class IngestPipelinesLocatorDefinition {
  constructor(deps) {
    (0, _defineProperty2.default)(this, "id", INGEST_PIPELINES_APP_LOCATOR);
    (0, _defineProperty2.default)(this, "getLocation", async params => {
      const location = await this.deps.managementAppLocator.getLocation({
        sectionId: 'ingest',
        appId: _constants.PLUGIN_ID
      });
      let path = '';
      switch (params.page) {
        case INGEST_PIPELINES_PAGES.EDIT:
          path = (0, _navigation.getEditPath)({
            pipelineName: params.pipelineId
          });
          break;
        case INGEST_PIPELINES_PAGES.CREATE:
          path = (0, _navigation.getCreatePath)();
          break;
        case INGEST_PIPELINES_PAGES.LIST:
          path = (0, _navigation.getListPath)({
            inspectedPipelineName: params.pipelineId
          });
          break;
        case INGEST_PIPELINES_PAGES.CLONE:
          path = (0, _navigation.getClonePath)({
            clonedPipelineName: params.pipelineId
          });
          break;
      }
      return {
        ...location,
        path: path === '/' ? location.path : location.path + path
      };
    });
    this.deps = deps;
  }
}
exports.IngestPipelinesLocatorDefinition = IngestPipelinesLocatorDefinition;