"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Remove = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _shared_imports = require("../../../../../../shared_imports");
var _shared = require("./shared");
var _ignore_missing_field = require("./common_fields/ignore_missing_field");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  emptyField
} = _shared_imports.fieldValidators;
const fieldsConfig = {
  field: {
    type: _shared_imports.FIELD_TYPES.COMBO_BOX,
    deserializer: _shared.to.arrayOfStrings,
    serializer: v => v.length === 1 ? v[0] : v,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.removeForm.fieldNameField', {
      defaultMessage: 'Fields'
    }),
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.removeForm.fieldNameHelpText', {
      defaultMessage: 'Fields to remove.'
    }),
    validations: [{
      validator: emptyField(_i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.removeForm.fieldNameRequiredError', {
        defaultMessage: 'A value is required.'
      }))
    }]
  }
};
const Remove = () => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    config: fieldsConfig.field,
    component: _shared_imports.ComboBoxField,
    path: "fields.field"
  }), /*#__PURE__*/_react.default.createElement(_ignore_missing_field.IgnoreMissingField, null));
};
exports.Remove = Remove;