"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CommunityId = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _shared = require("./shared");
var _target_field = require("./common_fields/target_field");
var _ignore_missing_field = require("./common_fields/ignore_missing_field");
var _shared_imports = require("../../../../../../shared_imports");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SEED_MIN_VALUE = 0;
const SEED_MAX_VALUE = 65535;
const seedValidator = {
  max: _shared_imports.fieldValidators.numberSmallerThanField({
    than: SEED_MAX_VALUE,
    allowEquality: true,
    message: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.communityId.seedMaxNumberError', {
      defaultMessage: `This number must be equal or less than {maxValue}.`,
      values: {
        maxValue: SEED_MAX_VALUE
      }
    })
  }),
  min: _shared_imports.fieldValidators.numberGreaterThanField({
    than: SEED_MIN_VALUE,
    allowEquality: true,
    message: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.communityId.seedMinNumberError', {
      defaultMessage: `This number must be equal or greater than {minValue}.`,
      values: {
        minValue: SEED_MIN_VALUE
      }
    })
  }),
  int: _shared_imports.fieldValidators.isInteger({
    message: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.communityId.integerRequiredError', {
      defaultMessage: 'Only integers are allowed.'
    })
  })
};
const fieldsConfig = {
  source_ip: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    serializer: _shared.from.emptyStringToUndefined,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.communityId.sourceIpLabel', {
      defaultMessage: 'Source IP (optional)'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.communityId.sourceIpHelpText",
      defaultMessage: "Field containing the source IP address. Defaults to {defaultValue}.",
      values: {
        defaultValue: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, 'source.ip')
      }
    })
  },
  source_port: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    serializer: _shared.from.emptyStringToUndefined,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.communityId.sourcePortLabel', {
      defaultMessage: 'Source port (optional)'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.communityId.sourcePortHelpText",
      defaultMessage: "Field containing the source port. Defaults to {defaultValue}.",
      values: {
        defaultValue: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, 'source.port')
      }
    })
  },
  destination_ip: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    serializer: _shared.from.emptyStringToUndefined,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.communityId.destinationIpLabel', {
      defaultMessage: 'Destination IP (optional)'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.communityId.destinationIpHelpText",
      defaultMessage: "Field containing the destination IP address. Defaults to {defaultValue}.",
      values: {
        defaultValue: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, 'destination.ip')
      }
    })
  },
  destination_port: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    serializer: _shared.from.emptyStringToUndefined,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.communityId.destinationPortLabel', {
      defaultMessage: 'Destination port (optional)'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.communityId.destinationPortHelpText",
      defaultMessage: "Field containing the destination port. Defaults to {defaultValue}.",
      values: {
        defaultValue: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, 'destination.port')
      }
    })
  },
  icmp_type: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    serializer: _shared.from.emptyStringToUndefined,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.communityId.icmpTypeLabel', {
      defaultMessage: 'ICMP type (optional)'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.communityId.icmpTypeHelpText",
      defaultMessage: "Field containing the destination ICMP type. Defaults to {defaultValue}.",
      values: {
        defaultValue: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, 'icmp.type')
      }
    })
  },
  icmp_code: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    serializer: _shared.from.emptyStringToUndefined,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.communityId.icmpCodeLabel', {
      defaultMessage: 'ICMP code (optional)'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.communityId.icmpCodeHelpText",
      defaultMessage: "Field containing the ICMP code. Defaults to {defaultValue}.",
      values: {
        defaultValue: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, 'icmp.code')
      }
    })
  },
  iana_number: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    serializer: _shared.from.emptyStringToUndefined,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.communityId.ianaLabel', {
      defaultMessage: 'IANA number (optional)'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.communityId.ianaNumberHelpText",
      defaultMessage: "Field containing the IANA number. Used only when {field} is not specified. Defaults to {defaultValue}.",
      values: {
        field: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, 'Transport'),
        defaultValue: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, 'network.iana_number')
      }
    })
  },
  transport: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    serializer: _shared.from.emptyStringToUndefined,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.communityId.transportLabel', {
      defaultMessage: 'Transport (optional)'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.communityId.transportHelpText",
      defaultMessage: "Field containing the transport protocol. Used only when {field} is not specified. Defaults to {defaultValue}.",
      values: {
        field: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, 'IANA number'),
        defaultValue: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, 'network.transport')
      }
    })
  },
  seed: {
    type: _shared_imports.FIELD_TYPES.NUMBER,
    formatters: [_shared_imports.fieldFormatters.toInt],
    serializer: _shared.from.undefinedIfValue(''),
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.communityId.seedLabel', {
      defaultMessage: 'Seed (optional)'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.communityId.seedHelpText",
      defaultMessage: "Seed for the community ID hash. Defaults to {defaultValue}.",
      values: {
        defaultValue: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, '0')
      }
    }),
    validations: [{
      validator: field => {
        if (field.value) {
          var _ref, _seedValidator$max;
          return (_ref = (_seedValidator$max = seedValidator.max(field)) !== null && _seedValidator$max !== void 0 ? _seedValidator$max : seedValidator.min(field)) !== null && _ref !== void 0 ? _ref : seedValidator.int(field);
        }
      }
    }]
  }
};
const CommunityId = () => {
  const [{
    fields
  }] = (0, _shared_imports.useFormData)({
    watch: ['fields.iana_number', 'fields.transport']
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    config: fieldsConfig.source_ip,
    component: _shared_imports.Field,
    path: "fields.source_ip",
    "data-test-subj": "sourceIpField"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    config: fieldsConfig.source_port,
    component: _shared_imports.Field,
    path: "fields.source_port",
    "data-test-subj": "sourcePortField"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    config: fieldsConfig.destination_ip,
    component: _shared_imports.Field,
    path: "fields.destination_ip",
    "data-test-subj": "destinationIpField"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    config: fieldsConfig.destination_port,
    component: _shared_imports.Field,
    path: "fields.destination_port",
    "data-test-subj": "destinationPortField"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    config: fieldsConfig.iana_number,
    component: _shared_imports.Field,
    path: "fields.iana_number",
    "data-test-subj": "ianaField",
    componentProps: {
      euiFieldProps: {
        disabled: !!(fields !== null && fields !== void 0 && fields.transport)
      }
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    config: fieldsConfig.transport,
    component: _shared_imports.Field,
    path: "fields.transport",
    "data-test-subj": "transportField",
    componentProps: {
      euiFieldProps: {
        disabled: !!(fields !== null && fields !== void 0 && fields.iana_number)
      }
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    config: fieldsConfig.icmp_type,
    component: _shared_imports.Field,
    path: "fields.icmp_type",
    "data-test-subj": "icmpTypeField"
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    config: fieldsConfig.icmp_code,
    component: _shared_imports.Field,
    path: "fields.icmp_code",
    "data-test-subj": "icmpCodeField"
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    config: fieldsConfig.seed,
    component: _shared_imports.NumericField,
    path: "fields.seed",
    "data-test-subj": "seedField",
    componentProps: {
      euiFieldProps: {
        min: SEED_MIN_VALUE,
        max: SEED_MAX_VALUE
      }
    }
  }), /*#__PURE__*/_react.default.createElement(_target_field.TargetField, {
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.communityId.targetFieldHelpText",
      defaultMessage: "Output field. Defaults to {field}.",
      values: {
        field: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, 'network.community_id')
      }
    })
  }), /*#__PURE__*/_react.default.createElement(_ignore_missing_field.IgnoreMissingField, {
    defaultValue: true,
    serializer: _shared.from.undefinedIfValue(true)
  }));
};
exports.CommunityId = CommunityId;