"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAllHosts = void 0;
var _server = require("@kbn/observability-plugin/server");
var _constants = require("../../../../../common/constants");
var _constants2 = require("../constants");
var _query = require("../helpers/query");
var _types = require("../../../../lib/metrics/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAllHosts = async ({
  infraMetricsClient,
  apmDocumentSources,
  from,
  to,
  limit,
  metrics,
  hostNames,
  apmDataAccessServices
}) => {
  var _response$aggregation, _response$aggregation2, _response$aggregation3, _response$aggregation4;
  const metricAggregations = (0, _query.getInventoryModelAggregations)('host', metrics.map(metric => metric));
  const documentsFilter = await (0, _query.getDocumentsFilter)({
    apmDataAccessServices,
    apmDocumentSources,
    from,
    to
  });
  const response = await infraMetricsClient.search({
    allow_no_indices: true,
    ignore_unavailable: true,
    size: 0,
    track_total_hits: false,
    query: {
      bool: {
        filter: [...(0, _server.termsQuery)(_constants.HOST_NAME_FIELD, ...hostNames), ...(0, _server.rangeQuery)(from, to)],
        should: [...documentsFilter]
      }
    },
    aggs: {
      // find hosts with metrics that are monitored by the system integration.
      monitoredHosts: {
        filter: (0, _query.getFilterByIntegration)('system'),
        aggs: {
          names: {
            terms: {
              field: _constants.HOST_NAME_FIELD,
              size: limit,
              order: {
                _key: 'asc'
              }
            }
          }
        }
      },
      allHostMetrics: {
        terms: {
          field: _constants.HOST_NAME_FIELD,
          size: limit,
          order: {
            _key: 'asc'
          }
        },
        aggs: {
          ...metricAggregations,
          [_constants2.METADATA_AGGREGATION_NAME]: {
            top_metrics: {
              metrics: [{
                field: 'host.os.name'
              }, {
                field: 'cloud.provider'
              }, {
                field: 'host.ip'
              }],
              size: 1,
              sort: {
                '@timestamp': 'desc'
              }
            }
          }
        }
      }
    }
  });
  const systemIntegrationHosts = new Set((_response$aggregation = (_response$aggregation2 = response.aggregations) === null || _response$aggregation2 === void 0 ? void 0 : _response$aggregation2.monitoredHosts.names.buckets.map(p => p.key)) !== null && _response$aggregation !== void 0 ? _response$aggregation : []);
  const result = ((_response$aggregation3 = (_response$aggregation4 = response.aggregations) === null || _response$aggregation4 === void 0 ? void 0 : _response$aggregation4.allHostMetrics.buckets) !== null && _response$aggregation3 !== void 0 ? _response$aggregation3 : []).sort((a, b) => {
    var _getMetricValue, _getMetricValue2;
    const hasASystemMetrics = systemIntegrationHosts.has(a === null || a === void 0 ? void 0 : a.key);
    const hasBSystemMetrics = systemIntegrationHosts.has(b === null || b === void 0 ? void 0 : b.key);
    if (hasASystemMetrics !== hasBSystemMetrics) {
      return hasASystemMetrics ? -1 : 1;
    }
    const aValue = (_getMetricValue = getMetricValue(a === null || a === void 0 ? void 0 : a.cpuV2)) !== null && _getMetricValue !== void 0 ? _getMetricValue : 0;
    const bValue = (_getMetricValue2 = getMetricValue(b === null || b === void 0 ? void 0 : b.cpuV2)) !== null && _getMetricValue2 !== void 0 ? _getMetricValue2 : 0;
    return bValue - aValue;
  }).map(bucket => {
    var _bucket$metadata$top;
    const hostName = bucket.key;
    const metadata = ((_bucket$metadata$top = bucket === null || bucket === void 0 ? void 0 : bucket.metadata.top) !== null && _bucket$metadata$top !== void 0 ? _bucket$metadata$top : []).flatMap(top => Object.entries(top.metrics)).map(([key, value]) => ({
      name: key,
      value: typeof value === 'string' && value.trim().length === 0 ? null : value
    }));
    return {
      name: hostName,
      metadata,
      metrics: metrics.map(metric => ({
        name: metric,
        value: getMetricValue(bucket[metric]) || null
      })),
      hasSystemMetrics: systemIntegrationHosts.has(hostName)
    };
  });
  return result;
};
exports.getAllHosts = getAllHosts;
const getMetricValue = valueObject => {
  if (_types.BasicMetricValueRT.is(valueObject)) {
    return valueObject.value;
  }
  return valueObject;
};