"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsExplorerToolbar = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/data-plugin/public");
var _kuery_bar = require("./kuery_bar");
var _metrics = require("./metrics");
var _group_by = require("./group_by");
var _aggregation = require("./aggregation");
var _chart_options = require("./chart_options");
var _use_kibana_ui_setting = require("../../../../hooks/use_kibana_ui_setting");
var _map_timepicker_quickranges_to_datepicker_ranges = require("../../../../utils/map_timepicker_quickranges_to_datepicker_ranges");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MetricsExplorerToolbar = ({
  timeRange,
  options,
  onTimeChange,
  onRefresh,
  onGroupByChange,
  onFilterQuerySubmit,
  onMetricsChange,
  onAggregationChange,
  chartOptions,
  onChartOptionsChange
}) => {
  const isDefaultOptions = options.aggregation === 'avg' && options.metrics.length === 0;
  const [timepickerQuickRanges] = (0, _use_kibana_ui_setting.useKibanaUiSetting)(_public.UI_SETTINGS.TIMEPICKER_QUICK_RANGES);
  const commonlyUsedRanges = (0, _map_timepicker_quickranges_to_datepicker_ranges.mapKibanaQuickRangesToDatePickerRanges)(timepickerQuickRanges);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: options.aggregation === 'count' ? 2 : false
  }, /*#__PURE__*/_react.default.createElement(_aggregation.MetricsExplorerAggregationPicker, {
    fullWidth: true,
    options: options,
    onChange: onAggregationChange
  })), options.aggregation !== 'count' && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.metricsExplorer.aggregationLabel",
    defaultMessage: "of"
  })), options.aggregation !== 'count' && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(_metrics.MetricsExplorerMetrics, {
    autoFocus: isDefaultOptions,
    options: options,
    onChange: onMetricsChange
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.metricsExplorer.groupByToolbarLabel",
    defaultMessage: "graph per"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_group_by.MetricsExplorerGroupBy, {
    onChange: onGroupByChange,
    options: options
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_kuery_bar.MetricsExplorerKueryBar, {
    onSubmit: onFilterQuerySubmit,
    value: options.filterQuery
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_chart_options.MetricsExplorerChartOptions, {
    onChange: onChartOptionsChange,
    chartOptions: chartOptions
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      marginRight: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperDatePicker, {
    start: timeRange.from,
    end: timeRange.to,
    onTimeChange: ({
      start,
      end
    }) => onTimeChange(start, end),
    onRefresh: onRefresh,
    commonlyUsedRanges: commonlyUsedRanges
  })))));
};
exports.MetricsExplorerToolbar = MetricsExplorerToolbar;