"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFilteredMetrics = void 0;
var _common = require("@kbn/metrics-data-access-plugin/common");
var _constants = require("../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getFilteredMetrics = (requiredMetrics, metadata) => {
  const metricMetadata = metadata.filter(data => data && data.source === 'metrics').map(data => data && data.name);
  return requiredMetrics.filter(metric => {
    var _metrics$tsvb$metric;
    const metricModelCreator = (_metrics$tsvb$metric = _common.metrics === null || _common.metrics === void 0 ? void 0 : _common.metrics.tsvb[metric]) !== null && _metrics$tsvb$metric !== void 0 ? _metrics$tsvb$metric : null;

    // We just need to get a dummy version of the model so we can filter
    // using the `requires` attribute.
    const metricModel = metricModelCreator ? metricModelCreator(_constants.TIMESTAMP_FIELD, 'test', '>=1m') : {
      requires: ['']
    }; // when tsvb is not defined (host & container)
    return metricMetadata.some(m => {
      var _metricModel$requires;
      return m && (metricModel === null || metricModel === void 0 ? void 0 : (_metricModel$requires = metricModel.requires) === null || _metricModel$requires === void 0 ? void 0 : _metricModel$requires.includes(m));
    });
  });
};
exports.getFilteredMetrics = getFilteredMetrics;