"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogsTabContent = exports.LogsSavedSearchComponent = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _savedSearchComponent = require("@kbn/saved-search-component");
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _common = require("@kbn/logs-shared-plugin/common");
var _public = require("@kbn/logs-shared-plugin/public");
var _use_kibana = require("../../../../../../hooks/use_kibana");
var _build = require("../../../../../../utils/filters/build");
var _use_hosts_view = require("../../../hooks/use_hosts_view");
var _use_unified_search = require("../../../hooks/use_unified_search");
var _use_logs_search_url_state = require("../../../hooks/use_logs_search_url_state");
var _logs_search_bar = require("./logs_search_bar");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LogsTabContent = () => {
  const {
    services: {
      logsShared: {
        LogsOverview
      }
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const isLogsOverviewEnabled = LogsOverview.useIsEnabled();
  return isLogsOverviewEnabled ? /*#__PURE__*/_react.default.createElement(LogsTabLogsOverviewContent, null) : /*#__PURE__*/_react.default.createElement(LogsSavedSearchComponent, null);
};
exports.LogsTabContent = LogsTabContent;
const LogsSavedSearchComponent = () => {
  const {
    services: {
      logsDataAccess: {
        services: {
          logSourcesService
        }
      },
      embeddable,
      dataViews,
      data: {
        search: {
          searchSource
        }
      },
      share: {
        url
      }
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const logSources = (0, _useAsync.default)(logSourcesService.getFlattenedLogSources);
  const logsLocator = (0, _common.getLogsLocatorFromUrlService)(url);
  const {
    parsedDateRange: {
      from,
      to
    }
  } = (0, _use_unified_search.useUnifiedSearchContext)();
  const {
    hostNodes,
    loading
  } = (0, _use_hosts_view.useHostsViewContext)();
  const [filterQuery] = (0, _use_logs_search_url_state.useLogsSearchUrlState)();
  const hostsFilterQuery = (0, _react.useMemo)(() => {
    const hostsQueryPart = hostNodes.length ? hostNodes.map(node => `host.name: "${node.name}"`).join(' or ') : '';
    const urlQueryPart = filterQuery !== null && filterQuery !== void 0 && filterQuery.query ? String(filterQuery.query) : '';
    const parts = [];
    if (hostsQueryPart) parts.push(hostsQueryPart);
    if (urlQueryPart) parts.push(`(${urlQueryPart})`);
    return {
      language: 'kuery',
      query: parts.join(' and ')
    };
  }, [hostNodes, filterQuery]);
  const memoizedTimeRange = (0, _react.useMemo)(() => ({
    from,
    to
  }), [from, to]);
  const discoverLink = logsLocator === null || logsLocator === void 0 ? void 0 : logsLocator.getRedirectUrl({
    timeRange: memoizedTimeRange,
    query: hostsFilterQuery
  });
  if (!hostNodes.length && !loading) {
    return /*#__PURE__*/_react.default.createElement(LogsTabNoResults, null);
  }
  return logSources.value ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    "data-test-subj": "hostsView-logs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_logs_search_bar.LogsSearchBar, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_public.OpenInLogsExplorerButton, {
    href: discoverLink,
    testSubject: "hostsView-logs-link-to-stream-button",
    flush: "both"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_savedSearchComponent.LazySavedSearchComponent, {
    dependencies: {
      embeddable,
      searchSource,
      dataViews
    },
    index: logSources.value,
    timeRange: memoizedTimeRange,
    query: hostsFilterQuery,
    height: "60vh",
    displayOptions: {
      solutionNavIdOverride: 'oblt',
      enableDocumentViewer: true,
      enableFilters: false
    }
  }))) : null;
};
exports.LogsSavedSearchComponent = LogsSavedSearchComponent;
const LogsTabNoResults = () => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  css: {
    height: '60vh'
  },
  direction: "column",
  alignItems: "stretch"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: true
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "xs",
  color: "subdued"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
  type: "discoverApp",
  size: "m",
  color: "subdued"
}), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "s"
}), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.infra.logs.noResultsFound",
  defaultMessage: "No results found"
}))));
const LogsTabLogsOverviewContent = () => {
  const {
    services: {
      logsShared: {
        LogsOverview
      }
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    parsedDateRange
  } = (0, _use_unified_search.useUnifiedSearchContext)();
  const timeRange = (0, _react.useMemo)(() => ({
    start: parsedDateRange.from,
    end: parsedDateRange.to
  }), [parsedDateRange.from, parsedDateRange.to]);
  const {
    hostNodes,
    loading,
    error
  } = (0, _use_hosts_view.useHostsViewContext)();
  const logFilters = (0, _react.useMemo)(() => [(0, _build.buildCombinedAssetFilter)({
    field: 'host.name',
    values: hostNodes.map(p => p.name)
  }).query], [hostNodes]);
  if (loading) {
    return /*#__PURE__*/_react.default.createElement(LogsOverview.LoadingContent, null);
  } else if (error != null) {
    return /*#__PURE__*/_react.default.createElement(LogsOverview.ErrorContent, {
      error: error
    });
  } else {
    return /*#__PURE__*/_react.default.createElement(LogsOverview, {
      documentFilters: logFilters,
      timeRange: timeRange
    });
  }
};