"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ControlTitle = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _popover = require("../common/popover");
var _control_panels_config = require("./control_panels_config");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const helpMessages = {
  [_control_panels_config.availableControlsPanels.SERVICE_NAME]: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.hostsViewPage.serviceNameControl.popoverHelpLabel",
    defaultMessage: "Services detected via {APMDocs}",
    values: {
      APMDocs: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: "https://ela.st/docs-infra-apm",
        target: "_blank",
        "data-test-subj": "hostsViewServiceNameControlPopoverHelpLink"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.hostsViewPage.serviceNameControl.popoverHelpLink",
        defaultMessage: "APM"
      }))
    }
  }))
};
const TitleWithPopoverMessage = ({
  title,
  helpMessage,
  embeddableId
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
    htmlFor: embeddableId
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    alignItems: "center",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, title), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_popover.Popover, {
    buttonAriaLabelText: title
  }, helpMessage))));
};
const ControlTitle = ({
  title,
  embeddableId
}) => {
  const helpMessage = helpMessages[embeddableId];
  return helpMessage ? /*#__PURE__*/_react.default.createElement(TitleWithPopoverMessage, {
    title: title,
    helpMessage: helpMessage,
    embeddableId: embeddableId
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
    htmlFor: embeddableId
  }, title);
};
exports.ControlTitle = ControlTitle;