"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostsTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _ebtTools = require("@kbn/ebt-tools");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_hosts_table = require("../hooks/use_hosts_table");
var _use_hosts_view = require("../hooks/use_hosts_view");
var _use_host_count = require("../hooks/use_host_count");
var _use_unified_search = require("../hooks/use_unified_search");
var _flyout_wrapper = require("./host_details_flyout/flyout_wrapper");
var _constants = require("../constants");
var _filter_action = require("./table/filter_action");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HostsTable = () => {
  var _pagination$pageIndex, _pagination$pageSize, _sorting$direction;
  const {
    loading
  } = (0, _use_hosts_view.useHostsViewContext)();
  const {
    loading: hostCountLoading,
    count
  } = (0, _use_host_count.useHostCountContext)();
  const {
    searchCriteria
  } = (0, _use_unified_search.useUnifiedSearchContext)();
  const {
    onPageReady
  } = (0, _ebtTools.usePerformanceContext)();
  const {
    columns,
    items,
    currentPage,
    isFlyoutOpen,
    closeFlyout,
    clickedItem,
    onTableChange,
    pagination,
    sorting,
    selection,
    selectedItemsCount,
    filterSelectedHosts
  } = (0, _use_hosts_table.useHostsTableContext)();
  (0, _react.useEffect)(() => {
    if (!loading && !hostCountLoading) {
      onPageReady({
        meta: {
          rangeFrom: searchCriteria.dateRange.from,
          rangeTo: searchCriteria.dateRange.to
        },
        customMetrics: {
          key1: 'num_of_hosts',
          value1: count,
          key2: `max_hosts_per_page`,
          value2: searchCriteria.limit
        }
      });
    }
  }, [loading, hostCountLoading, onPageReady, count, searchCriteria]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_filter_action.FilterAction, {
    selectedItemsCount: selectedItemsCount,
    filterSelectedHosts: filterSelectedHosts
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    "data-test-subj": `hostsView-table-${loading ? 'loading' : 'loaded'}`
    // This table has a lot of columns, so break down into mobile view sooner
    ,
    responsiveBreakpoint: "xl",
    itemId: "id",
    selection: selection,
    pagination: {
      pageIndex: (_pagination$pageIndex = pagination.pageIndex) !== null && _pagination$pageIndex !== void 0 ? _pagination$pageIndex : 0,
      pageSize: (_pagination$pageSize = pagination.pageSize) !== null && _pagination$pageSize !== void 0 ? _pagination$pageSize : _constants.DEFAULT_PAGE_SIZE,
      totalItemCount: items.length,
      pageSizeOptions: _constants.PAGE_SIZE_OPTIONS
    },
    sorting: {
      sort: {
        field: sorting.field,
        direction: (_sorting$direction = sorting.direction) !== null && _sorting$direction !== void 0 ? _sorting$direction : 'asc'
      }
    },
    rowProps: {
      'data-test-subj': 'hostsView-tableRow'
    },
    items: currentPage,
    columns: columns,
    loading: loading,
    onChange: onTableChange,
    noItemsMessage: loading ? _i18n.i18n.translate('xpack.infra.waffle.loadingDataText', {
      defaultMessage: 'Loading data'
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      body: _i18n.i18n.translate('xpack.infra.waffle.noDataDescription', {
        defaultMessage: 'Try adjusting your time or filter.'
      }),
      "data-test-subj": "hostsViewTableNoData",
      layout: "vertical",
      title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.infra.waffle.noDataTitle', {
        defaultMessage: 'There is no data to display.'
      })),
      hasBorder: false,
      titleSize: "m"
    })
  }), isFlyoutOpen && clickedItem && /*#__PURE__*/_react.default.createElement(_flyout_wrapper.FlyoutWrapper, {
    node: clickedItem,
    closeFlyout: closeFlyout
  }));
};
exports.HostsTable = HostsTable;