"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withSourceProvider = exports.useSourceFetcher = exports.useSourceContext = exports.useSource = exports.SourceProvider = void 0;
var _constate = _interopRequireDefault(require("constate"));
var _react = _interopRequireWildcard(require("react"));
var _use_kibana = require("../../hooks/use_kibana");
var _use_tracked_promise = require("../../hooks/use_tracked_promise");
var _source_errors = require("./source_errors");
var _notifications = require("./notifications");
var _metrics_view = require("./metrics_view");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const API_URL = `/api/metrics/source`;
const useSourceFetcher = ({
  sourceId
}) => {
  const [source, setSource] = (0, _react.useState)(undefined);
  const {
    services: {
      http,
      telemetry
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const notify = (0, _notifications.useSourceNotifier)();
  const [loadSourceRequest, loadSource] = (0, _use_tracked_promise.useTrackedPromise)({
    cancelPreviousOn: 'resolution',
    createPromise: async () => {
      if (!http) {
        throw new _source_errors.MissingHttpClientException();
      }
      const start = performance.now();
      const response = await http.fetch(`${API_URL}/${sourceId}`, {
        method: 'GET'
      });
      telemetry === null || telemetry === void 0 ? void 0 : telemetry.reportPerformanceMetricEvent('infra_source_load', performance.now() - start, {}, {});
      return response;
    },
    onResolve: response => {
      if (response) {
        setSource(response.source);
      }
    }
  }, [http, sourceId]);
  const [persistSourceConfigurationRequest, persistSourceConfiguration] = (0, _use_tracked_promise.useTrackedPromise)({
    createPromise: async sourceProperties => {
      if (!http) {
        throw new _source_errors.MissingHttpClientException();
      }
      return await http.patch(`${API_URL}/${sourceId}`, {
        method: 'PATCH',
        body: JSON.stringify(sourceProperties)
      });
    },
    onResolve: response => {
      if (response) {
        notify.updateSuccess();
        setSource(response.source);
      }
    },
    onReject: error => {
      var _body;
      notify.updateFailure((_body = error.body) === null || _body === void 0 ? void 0 : _body.message);
    }
  }, [http, sourceId]);
  (0, _react.useEffect)(() => {
    loadSource();
  }, [loadSource, sourceId]);
  const error = loadSourceRequest.state === 'rejected' ? `${loadSourceRequest.value}` : undefined;
  const isLoading = loadSourceRequest.state === 'uninitialized' || loadSourceRequest.state === 'pending' || persistSourceConfigurationRequest.state === 'pending';
  return {
    error,
    loadSource,
    isLoading,
    source,
    persistSourceConfiguration
  };
};
exports.useSourceFetcher = useSourceFetcher;
const useSource = ({
  sourceId
}) => {
  var _source$status;
  const {
    persistSourceConfiguration,
    source,
    error,
    isLoading,
    loadSource
  } = useSourceFetcher({
    sourceId
  });
  const sourceExists = source ? !!source.version : undefined;
  const metricIndicesExist = Boolean(source === null || source === void 0 ? void 0 : (_source$status = source.status) === null || _source$status === void 0 ? void 0 : _source$status.metricIndicesExist);
  return {
    isLoading,
    error,
    loadSource,
    metricIndicesExist,
    source,
    sourceExists,
    sourceId,
    persistSourceConfiguration
  };
};
exports.useSource = useSource;
const [SourceProvider, useSourceContext] = (0, _constate.default)(useSource);
exports.useSourceContext = useSourceContext;
exports.SourceProvider = SourceProvider;
const withSourceProvider = Component => (sourceId = 'default') => {
  return function ComponentWithSourceProvider(props) {
    return /*#__PURE__*/_react.default.createElement(SourceProvider, {
      sourceId: sourceId
    }, /*#__PURE__*/_react.default.createElement(_metrics_view.MetricsDataViewProvider, null, /*#__PURE__*/_react.default.createElement(Component, props)));
  };
};
exports.withSourceProvider = withSourceProvider;