"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CategoryJobNoticesSection = void 0;
var _react = _interopRequireDefault(require("react"));
var _log_analysis_job_problem_indicator = require("./log_analysis_job_problem_indicator");
var _quality_warning_notices = require("./quality_warning_notices");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CategoryJobNoticesSection = ({
  hasOutdatedJobConfigurations,
  hasOutdatedJobDefinitions,
  hasSetupCapabilities,
  hasStoppedJobs,
  isFirstUse,
  moduleName,
  onRecreateMlJobForReconfiguration,
  onRecreateMlJobForUpdate,
  qualityWarnings
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_log_analysis_job_problem_indicator.LogAnalysisJobProblemIndicator, {
  hasOutdatedJobConfigurations: hasOutdatedJobConfigurations,
  hasOutdatedJobDefinitions: hasOutdatedJobDefinitions,
  hasSetupCapabilities: hasSetupCapabilities,
  hasStoppedJobs: hasStoppedJobs,
  isFirstUse: isFirstUse,
  moduleName: moduleName,
  onRecreateMlJobForReconfiguration: onRecreateMlJobForReconfiguration,
  onRecreateMlJobForUpdate: onRecreateMlJobForUpdate
}), /*#__PURE__*/_react.default.createElement(_quality_warning_notices.CategoryQualityWarnings, {
  hasSetupCapabilities: hasSetupCapabilities,
  qualityWarnings: qualityWarnings,
  onRecreateMlJob: onRecreateMlJobForReconfiguration
}));
exports.CategoryJobNoticesSection = CategoryJobNoticesSection;