"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LoadingOverlayWrapper = void 0;
var _eui = require("@elastic/eui");
var _polished = require("polished");
var _react = _interopRequireDefault(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LoadingOverlayWrapper = ({
  children,
  isLoading,
  loadingChildren,
  ...rest
}) => {
  return /*#__PURE__*/_react.default.createElement(RelativeDiv, rest, children, isLoading ? /*#__PURE__*/_react.default.createElement(Overlay, null, loadingChildren) : null);
};
exports.LoadingOverlayWrapper = LoadingOverlayWrapper;
const Overlay = ({
  children
}) => /*#__PURE__*/_react.default.createElement(OverlayDiv, null, children ? children : /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
  size: "xl"
}));
const RelativeDiv = _styled.default.div`
  position: relative;
`;
const OverlayDiv = _styled.default.div`
  align-items: center;
  background-color: ${props => (0, _polished.transparentize)(0.3, props.theme.euiTheme.colors.emptyShade)};
  display: flex;
  height: 100%;
  justify-content: center;
  left: 0;
  position: absolute;
  top: 0;
  width: 100%;
  z-index: ${props => props.theme.euiTheme.levels.maskBelowHeader};
`;