"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Anomalies = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/observability-shared-plugin/public");
var _anomalies_table = require("../../../ml/anomaly_detection/anomalies_table/anomalies_table");
var _use_asset_details_render_props = require("../../hooks/use_asset_details_render_props");
var _use_date_picker = require("../../hooks/use_date_picker");
var _use_request_observable = require("../../hooks/use_request_observable");
var _use_kibana = require("../../../../hooks/use_kibana");
var _flyout_home = require("../../../ml/anomaly_detection/flyout_home");
var _use_tab_switcher = require("../../hooks/use_tab_switcher");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Anomalies = () => {
  const ref = (0, _react.useRef)(null);
  const {
    isActiveTab
  } = (0, _use_tab_switcher.useTabSwitcherContext)();
  const {
    request$
  } = (0, _use_request_observable.useRequestObservable)();
  const {
    getParsedDateRange
  } = (0, _use_date_picker.useDatePickerContext)();
  const {
    asset
  } = (0, _use_asset_details_render_props.useAssetDetailsRenderPropsContext)();
  const {
    kibanaVersion,
    isCloudEnv,
    isServerlessEnv
  } = (0, _react.useContext)(_use_kibana.KibanaEnvironmentContext);
  const parsedDateRange = (0, _react.useMemo)(() => getParsedDateRange(), [getParsedDateRange]);
  return /*#__PURE__*/_react.default.createElement("div", {
    ref: ref
  }, /*#__PURE__*/_react.default.createElement(_anomalies_table.AnomaliesTable, {
    hostName: asset.name,
    dateRange: parsedDateRange,
    hideDatePicker: true,
    fetcherOpts: {
      autoFetch: isActiveTab('anomalies'),
      requestObservable$: request$
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      position: 'fixed',
      bottom: '24px',
      right: '24px',
      display: 'flex',
      justifyContent: 'flex-end',
      alignItems: 'flex-end'
    }
  }, /*#__PURE__*/_react.default.createElement(_public.FeatureFeedbackButton, {
    "data-test-subj": "infraMLHostFlyoutFeedbackLink",
    formUrl: _flyout_home.INFRA_ML_FLYOUT_FEEDBACK_LINK,
    sanitizedPath: document.location.pathname,
    kibanaVersion: kibanaVersion,
    isCloudEnv: isCloudEnv,
    isServerlessEnv: isServerlessEnv,
    nodeType: "host"
  })));
};
exports.Anomalies = Anomalies;