"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTemplateHeaderBreadcrumbs = exports.usePageHeader = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _plugin_config_context = require("../../../containers/plugin_config_context");
var _use_kibana = require("../../../hooks/use_kibana");
var _use_profiling_integration_setting = require("../../../hooks/use_profiling_integration_setting");
var _create_alert_rule_button = require("../../shared/alerts/links/create_alert_rule_button");
var _links = require("../links");
var _types = require("../types");
var _use_asset_details_render_props = require("./use_asset_details_render_props");
var _use_tab_switcher = require("./use_tab_switcher");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const usePageHeader = (tabs = [], links = []) => {
  const {
    rightSideItems
  } = useRightSideItems(links);
  const {
    tabEntries
  } = useTabs(tabs);
  const {
    breadcrumbs
  } = useTemplateHeaderBreadcrumbs();
  return {
    rightSideItems,
    tabEntries,
    breadcrumbs
  };
};
exports.usePageHeader = usePageHeader;
const useTemplateHeaderBreadcrumbs = () => {
  const history = (0, _reactRouterDom.useHistory)();
  const location = (0, _reactRouterDom.useLocation)();
  const {
    services: {
      application: {
        navigateToApp
      }
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const onClick = e => {
    if (location.state) {
      navigateToApp(location.state.originAppId, {
        replace: true,
        path: `${location.state.originPathname}${location.state.originSearch}`
      });
    } else {
      history.goBack();
    }
    e.preventDefault();
  };
  const breadcrumbs =
  // If there is a state object in location, it's persisted in case the page is opened in a new tab or after page refresh
  // With that, we can show the return button. Otherwise, it will be hidden (ex: the user opened a shared URL or opened the page from their bookmarks)
  !(0, _lodash.isEmpty)(location.state) || history.length > 1 ? [{
    text: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      alignItems: "center",
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "s",
      type: "arrowLeft"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.assetDetails.header.return",
      defaultMessage: "Return"
    }))),
    color: 'primary',
    'aria-current': false,
    'data-test-subj': 'infraAssetDetailsReturnButton',
    href: '#',
    onClick
  }] : [];
  return {
    breadcrumbs
  };
};
exports.useTemplateHeaderBreadcrumbs = useTemplateHeaderBreadcrumbs;
const useRightSideItems = links => {
  const {
    asset
  } = (0, _use_asset_details_render_props.useAssetDetailsRenderPropsContext)();
  const topCornerLinkComponents = (0, _react.useMemo)(() => ({
    nodeDetails: /*#__PURE__*/_react.default.createElement(_links.LinkToNodeDetails, {
      assetId: asset.id,
      assetName: asset.name,
      assetType: asset.type
    }),
    alertRule: /*#__PURE__*/_react.default.createElement(_create_alert_rule_button.CreateAlertRuleButton, {
      "data-test-subj": "infraAssetDetailsPageHeaderCreateAlertsRuleButton"
    })
  }), [asset.id, asset.name, asset.type]);
  const rightSideItems = (0, _react.useMemo)(() => links === null || links === void 0 ? void 0 : links.map(link => topCornerLinkComponents[link]), [links, topCornerLinkComponents]);
  return {
    rightSideItems
  };
};
const useFeatureFlagTabs = () => {
  const {
    featureFlags
  } = (0, _plugin_config_context.usePluginConfig)();
  const isProfilingPluginEnabled = (0, _use_profiling_integration_setting.useProfilingPluginSetting)();
  const featureFlagControlledTabs = (0, _react.useMemo)(() => ({
    [_types.ContentTabIds.OSQUERY]: Boolean(featureFlags.osqueryEnabled),
    [_types.ContentTabIds.PROFILING]: Boolean(isProfilingPluginEnabled)
  }), [featureFlags.osqueryEnabled, isProfilingPluginEnabled]);
  const isTabEnabled = (0, _react.useCallback)(tabItem => {
    var _featureFlagControlle;
    return (_featureFlagControlle = featureFlagControlledTabs[tabItem.id]) !== null && _featureFlagControlle !== void 0 ? _featureFlagControlle : true;
  }, [featureFlagControlledTabs]);
  return {
    isTabEnabled
  };
};
const useTabs = tabs => {
  const {
    showTab,
    activeTabId
  } = (0, _use_tab_switcher.useTabSwitcherContext)();
  const {
    isTabEnabled
  } = useFeatureFlagTabs();
  const onTabClick = (0, _react.useCallback)(tabId => {
    showTab(tabId);
  }, [showTab]);
  const tabEntries = (0, _react.useMemo)(() => tabs.filter(isTabEnabled).map(({
    name,
    ...tab
  }) => {
    return {
      ...tab,
      'data-test-subj': `infraAssetDetails${(0, _lodash.capitalize)(tab.id)}Tab`,
      onClick: () => onTabClick(tab.id),
      isSelected: tab.id === activeTabId,
      label: name
    };
  }), [activeTabId, isTabEnabled, onTabClick, tabs]);
  return {
    tabEntries
  };
};