"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMetadata = useMetadata;
var _ioTsUtils = require("@kbn/io-ts-utils");
var _use_fetcher = require("../../../hooks/use_fetcher");
var _metadata_api = require("../../../../common/http_api/metadata_api");
var _get_filtered_metrics = require("../../../pages/metrics/metric_detail/lib/get_filtered_metrics");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useMetadata({
  assetId,
  assetType,
  sourceId,
  timeRange,
  requiredMetrics = [],
  request$
}) {
  var _data$info, _data$info$cloud, _data$info$cloud$inst;
  const {
    data,
    status,
    error,
    refetch
  } = (0, _use_fetcher.useFetcher)(async callApi => {
    const response = await callApi('/api/infra/metadata', {
      method: 'POST',
      body: JSON.stringify({
        nodeId: assetId,
        nodeType: assetType,
        sourceId,
        timeRange
      })
    });
    return (0, _ioTsUtils.decodeOrThrow)(_metadata_api.InfraMetadataRT)(response);
  }, [assetId, assetType, sourceId, timeRange], {
    requestObservable$: request$
  });
  return {
    name: data && data.name || '',
    filteredRequiredMetrics: data && requiredMetrics.length > 0 ? (0, _get_filtered_metrics.getFilteredMetrics)(requiredMetrics, data.features) : [],
    error: error && error.message || null,
    loading: (0, _use_fetcher.isPending)(status),
    metadata: data,
    cloudId: (data === null || data === void 0 ? void 0 : (_data$info = data.info) === null || _data$info === void 0 ? void 0 : (_data$info$cloud = _data$info.cloud) === null || _data$info$cloud === void 0 ? void 0 : (_data$info$cloud$inst = _data$info$cloud.instance) === null || _data$info$cloud$inst === void 0 ? void 0 : _data$info$cloud$inst.id) || '',
    reload: refetch
  };
}