"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Chart = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _data_view = require("../../../utils/data_view");
var _use_kibana = require("../../../hooks/use_kibana");
var _constants = require("../../../common/visualizations/constants");
var _build = require("../../../utils/filters/build");
var _lens = require("../../lens");
var _use_date_picker = require("../hooks/use_date_picker");
var _chart_utils = require("./chart_utils");
var _use_reload_request_time = require("../../../hooks/use_reload_request_time");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Chart = ({
  id,
  queryField,
  overrides,
  dateRange,
  assetId,
  lensAttributes,
  dataView
}) => {
  const {
    setDateRange
  } = (0, _use_date_picker.useDatePickerContext)();
  const {
    reloadRequestTime
  } = (0, _use_reload_request_time.useReloadRequestTimeContext)();
  const {
    services: {
      dataViews
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    value: filters = []
  } = (0, _useAsync.default)(async () => {
    if (!(dataView !== null && dataView !== void 0 && dataView.id)) {
      return [];
    }
    const resolvedDataView = await (0, _data_view.resolveDataView)({
      dataViewId: dataView.id,
      dataViewsService: dataViews
    });
    return [(0, _build.buildCombinedAssetFilter)({
      field: queryField,
      values: [assetId],
      dataView: resolvedDataView.dataViewReference
    })];
  }, [assetId, dataView === null || dataView === void 0 ? void 0 : dataView.id, dataViews, queryField]);
  const handleBrushEnd = (0, _react.useCallback)(({
    range,
    preventDefault
  }) => {
    setDateRange({
      from: new Date(range[0]).toISOString(),
      to: new Date(range[1]).toISOString()
    });
    preventDefault();
  }, [setDateRange]);
  const handleFilter = (0, _react.useCallback)(event => {
    const range = (0, _chart_utils.extractRangeFromChartFilterEvent)(event);
    if (range === null) {
      return;
    }
    setDateRange(range);
    event.preventDefault();
  }, [setDateRange]);
  return /*#__PURE__*/_react.default.createElement(_lens.LensChart, {
    id: `infraAssetDetailsMetricChart${id}`,
    borderRadius: "m",
    dateRange: dateRange,
    height: _constants.METRIC_CHART_HEIGHT,
    lastReloadRequestTime: reloadRequestTime,
    filters: filters,
    lensAttributes: lensAttributes,
    overrides: overrides,
    onBrushEnd: handleBrushEnd,
    onFilter: handleFilter
  });
};
exports.Chart = Chart;