"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CriterionPreview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _i18n = require("@kbn/i18n");
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _ioTsUtils = require("@kbn/io-ts-utils");
var _use_timeline_chart_theme = require("../../../../hooks/use_timeline_chart_theme");
var _criterion_preview_chart = require("../../../common/criterion_preview_chart/criterion_preview_chart");
var _types = require("../../../../../common/alerting/logs/log_threshold/types");
var _color_palette = require("../../../../../common/color_palette");
var _http_api = require("../../../../../common/http_api");
var _use_chart_preview_data = require("./hooks/use_chart_preview_data");
var _use_kibana_time_zone_setting = require("../../../../hooks/use_kibana_time_zone_setting");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GROUP_LIMIT = 5;
const CriterionPreview = ({
  ruleParams,
  chartCriterion,
  logViewReference,
  showThreshold,
  executionTimeRange,
  annotations,
  filterSeriesByGroupName
}) => {
  const chartAlertParams = (0, _react.useMemo)(() => {
    const {
      field,
      comparator,
      value
    } = chartCriterion;
    const criteria = field && comparator && value ? [{
      field,
      comparator,
      value
    }] : [];
    const params = {
      criteria,
      count: {
        comparator: ruleParams.count.comparator,
        value: ruleParams.count.value
      },
      timeSize: ruleParams.timeSize,
      timeUnit: ruleParams.timeUnit,
      groupBy: ruleParams.groupBy
    };
    try {
      return (0, _ioTsUtils.decodeOrThrow)(_http_api.getLogAlertsChartPreviewDataAlertParamsSubsetRT)(params);
    } catch (error) {
      return null;
    }
  }, [ruleParams.timeSize, ruleParams.timeUnit, ruleParams.groupBy, ruleParams.count.comparator, ruleParams.count.value, chartCriterion]);

  // Check for the existence of properties that are necessary for a meaningful chart.
  if (chartAlertParams === null || chartAlertParams.criteria.length === 0) return null;
  return /*#__PURE__*/_react.default.createElement(CriterionPreviewChart, {
    buckets: executionTimeRange !== null && executionTimeRange !== void 0 && executionTimeRange.buckets ? executionTimeRange.buckets : !chartAlertParams.groupBy || chartAlertParams.groupBy.length === 0 ? _criterion_preview_chart.NUM_BUCKETS : _criterion_preview_chart.NUM_BUCKETS / 4 // Display less data for groups due to space limitations
    ,
    logViewReference: logViewReference,
    threshold: ruleParams.count,
    chartAlertParams: chartAlertParams,
    showThreshold: showThreshold,
    executionTimeRange: executionTimeRange,
    annotations: annotations,
    filterSeriesByGroupName: filterSeriesByGroupName
  });
};
exports.CriterionPreview = CriterionPreview;
const CriterionPreviewChart = ({
  buckets,
  logViewReference,
  threshold,
  chartAlertParams,
  showThreshold,
  executionTimeRange,
  annotations,
  filterSeriesByGroupName
}) => {
  const chartTheme = (0, _use_timeline_chart_theme.useTimelineChartTheme)();
  const timezone = (0, _use_kibana_time_zone_setting.useKibanaTimeZoneSetting)();
  const {
    getChartPreviewData,
    isLoading,
    hasError,
    chartPreviewData: series
  } = (0, _use_chart_preview_data.useChartPreviewData)({
    logViewReference,
    ruleParams: chartAlertParams,
    buckets,
    executionTimeRange
  });
  (0, _useDebounce.default)(() => {
    getChartPreviewData();
  }, 500, [getChartPreviewData]);
  const isStacked = false;
  const {
    timeSize,
    timeUnit,
    groupBy
  } = chartAlertParams;
  const isGrouped = groupBy && groupBy.length > 0 ? true : false;
  const isAbove = showThreshold && threshold && threshold.comparator ? [_types.Comparator.GT, _types.Comparator.GT_OR_EQ].includes(threshold.comparator) : false;
  const isBelow = showThreshold && threshold && threshold.comparator ? [_types.Comparator.LT, _types.Comparator.LT_OR_EQ].includes(threshold.comparator) : false;

  // For grouped scenarios we want to limit the groups displayed, for "isAbove" thresholds we'll show
  // groups with the highest doc counts. And for "isBelow" thresholds we'll show groups with the lowest doc counts.
  // Ratio scenarios will just default to max.
  const filteredSeries = (0, _react.useMemo)(() => {
    if (!isGrouped) {
      return series;
    }
    if (filterSeriesByGroupName && filterSeriesByGroupName.length) {
      return series.filter(item => filterSeriesByGroupName === item.id);
    }
    const sortedByMax = series.sort((a, b) => {
      const aMax = Math.max(...a.points.map(point => point.value));
      const bMax = Math.max(...b.points.map(point => point.value));
      return bMax - aMax;
    });
    const sortedSeries = !isAbove && !isBelow || isAbove ? sortedByMax : sortedByMax.reverse();
    return sortedSeries.slice(0, GROUP_LIMIT);
  }, [isGrouped, filterSeriesByGroupName, series, isAbove, isBelow]);
  const barSeries = (0, _react.useMemo)(() => {
    return filteredSeries.reduce((acc, serie) => {
      const barPoints = serie.points.reduce((pointAcc, point) => {
        return [...pointAcc, {
          ...point,
          groupBy: serie.id
        }];
      }, []);
      return [...acc, ...barPoints];
    }, []);
  }, [filteredSeries]);
  const lookback = timeSize * buckets;
  const hasData = series.length > 0;
  const {
    yMin,
    yMax,
    xMin,
    xMax
  } = (0, _criterion_preview_chart.getDomain)(filteredSeries, isStacked);
  const chartDomain = {
    max: showThreshold && threshold ? Math.max(yMax, threshold.value) * 1.1 : yMax * 1.1,
    // Add 10% headroom.
    min: showThreshold && threshold ? Math.min(yMin, threshold.value) : yMin
  };
  if (showThreshold && threshold && chartDomain.min === threshold.value) {
    chartDomain.min = chartDomain.min * 0.9; // Allow some padding so the threshold annotation has better visibility
  }
  const THRESHOLD_OPACITY = 0.3;
  const groupByLabel = groupBy && groupBy.length > 0 ? groupBy.join(', ') : null;
  const dateFormatter = (0, _criterion_preview_chart.useDateFormatter)(xMin, xMax);
  const timeLabel = _criterion_preview_chart.TIME_LABELS[timeUnit];
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_criterion_preview_chart.LoadingState, null);
  } else if (hasError) {
    return /*#__PURE__*/_react.default.createElement(_criterion_preview_chart.ErrorState, null);
  } else if (!hasData) {
    return /*#__PURE__*/_react.default.createElement(_criterion_preview_chart.NoDataState, null);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_criterion_preview_chart.ChartContainer, null, /*#__PURE__*/_react.default.createElement(_charts.Chart, null, /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
    id: "criterion-preview"
    // Defaults to multi layer time axis as of Elastic Charts v70
    ,
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: "timestamp",
    yAccessors: ['value'],
    splitSeriesAccessors: ['groupBy'],
    stackAccessors: isStacked ? ['timestamp'] : undefined,
    data: barSeries,
    barSeriesStyle: {
      rectBorder: {
        stroke: !isGrouped ? (0, _color_palette.colorTransformer)(_color_palette.Color.color0) : undefined,
        strokeWidth: 1,
        visible: true
      },
      rect: {
        opacity: 1
      }
    },
    color: !isGrouped ? (0, _color_palette.colorTransformer)(_color_palette.Color.color0) : undefined,
    timeZone: timezone
  }), showThreshold && threshold ? /*#__PURE__*/_react.default.createElement(_charts.LineAnnotation, {
    id: `threshold-line`,
    domainType: _charts.AnnotationDomainType.YDomain,
    dataValues: [{
      dataValue: threshold.value
    }],
    style: {
      line: {
        strokeWidth: 2,
        stroke: (0, _color_palette.colorTransformer)(_color_palette.Color.color1),
        opacity: 1
      }
    }
  }) : null, showThreshold && threshold && isBelow ? /*#__PURE__*/_react.default.createElement(_charts.RectAnnotation, {
    id: "below-threshold",
    style: {
      fill: (0, _color_palette.colorTransformer)(_color_palette.Color.color1),
      opacity: THRESHOLD_OPACITY
    },
    dataValues: [{
      coordinates: {
        x0: xMin,
        x1: xMax,
        y0: chartDomain.min,
        y1: threshold.value
      }
    }]
  }) : null, annotations, showThreshold && threshold && isAbove ? /*#__PURE__*/_react.default.createElement(_charts.RectAnnotation, {
    id: "above-threshold",
    style: {
      fill: (0, _color_palette.colorTransformer)(_color_palette.Color.color1),
      opacity: THRESHOLD_OPACITY
    },
    dataValues: [{
      coordinates: {
        x0: xMin,
        x1: xMax,
        y0: threshold.value,
        y1: chartDomain.max
      }
    }]
  }) : null, /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: 'timestamp',
    position: _charts.Position.Bottom,
    showOverlappingTicks: true,
    tickFormat: dateFormatter
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: 'values',
    position: _charts.Position.Left,
    tickFormat: _criterion_preview_chart.yAxisFormatter,
    domain: chartDomain
  }), /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    baseTheme: chartTheme.baseTheme,
    theme: {
      chartMargins: {
        top: 35
      }
    },
    locale: _i18n.i18n.getLocale()
  }), /*#__PURE__*/_react.default.createElement(_charts.Tooltip, _criterion_preview_chart.tooltipProps))), !executionTimeRange && /*#__PURE__*/_react.default.createElement("div", {
    style: {
      textAlign: 'center'
    }
  }, groupByLabel != null ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.logs.alerts.dataTimeRangeLabelWithGrouping",
    defaultMessage: "Last {lookback} {timeLabel} of data, grouped by {groupByLabel} (showing {displayedGroups}/{totalGroups} groups)",
    values: {
      groupByLabel,
      timeLabel,
      lookback,
      displayedGroups: filteredSeries.length,
      totalGroups: series.length
    }
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.logs.alerts.dataTimeRangeLabel",
    defaultMessage: "Last {lookback} {timeLabel} of data",
    values: {
      timeLabel,
      lookback
    }
  }))));
};